
#import "point3.h"
#import "api.h"
#import "EditObject.h"

@implementation EditObject
;

static id editPanelID, positionFormID, strengthSliderID, 
  stretchinessSliderID, selfID;

- cancel:sender
{
  apiThaw();
  [editPanel performClose:self];
  [NXApp stopModal];
  return self;
}

- awakeFromNib
{
  editPanelID = editPanel;
  positionFormID = positionForm;
  strengthSliderID = strengthSlider;
  stretchinessSliderID = stretchinessSlider;
  selfID = self;
  [editPanel setAvoidsActivation:YES];
  return self;
}
    

- readLocation:sender
{
  apiEditLocation();
  return self;
}

- set:sender
{
  apiEditSet();
  apiThaw();
  [editPanel performClose:self];
  [NXApp stopModal];
  return self;
}

- setAll:sender
{
  apiEditSetAll();
  apiThaw();
  [editPanel performClose:self];
  [NXApp stopModal];
  return self;
}

- openPanel:sender
{
  apiEdit();
  return self;
}

void uiSetSmoothnessBounds(float min, float max) {
  [stretchinessSliderID setMinValue:min];
  [stretchinessSliderID setMaxValue:max];
}

void uiSetSmoothness(float smoothness) {
  [stretchinessSliderID setFloatValue:smoothness];
}

float uiGetSmoothness() {
  return [stretchinessSliderID floatValue];
}

void uiSetStrengthBounds(float min, float max) { 
  [strengthSliderID setMinValue:min];
  [strengthSliderID setMaxValue:max];
}
	
void uiSetStrength(float strength) {
  [strengthSliderID setFloatValue:strength];
}

float uiGetStrength() {
  return [strengthSliderID floatValue]; 
}

void uiSetPoint(Point3 *pt) {
  [positionFormID setFloatValue:pt->x at:0];
  [positionFormID setFloatValue:pt->y at:1];
  [positionFormID setFloatValue:pt->z at:2];
}

void uiGetPoint(Point3 *pt) {
  pt->x = [positionFormID floatValueAt:0];
  pt->y = [positionFormID floatValueAt:1];
  pt->z = [positionFormID floatValueAt:2];
}		     

void uiEdit(const char *name) {
  apiFreeze();
  [editPanelID setTitle:name];
  [editPanelID makeKeyAndOrderFront:selfID];
  [NXApp runModalFor:editPanelID];
}

@end
