#include <stdio.h>
#include <string.h>
#include "point3.h"
#include "forms.h"
#include "formsx.h"
#include "panel.h"
#include "api.h"

main() {

  foreground();
  create_the_forms();
  apiInit();
  fl_show_form(MainForm, FL_PLACE_SIZE, TRUE, "Warp");

  while(1) {
    apiCheckPipes();
    fl_check_forms();
  }

}

/* Button call-backs */
void uiPreviewProc(FL_OBJECT *obj, long val) {
  apiPreview();
}

void ObjectProc(FL_OBJECT *obj, long val) {
  apiTargetChanged();
}

void uiOptionsProc(FL_OBJECT *obj, long val) {
  fl_show_form(OptionsForm, FL_PLACE_SIZE, TRUE, "Options");
}

void uiWarpProc(FL_OBJECT *obj, long val) {
  apiWarp();
}

void uiQuitProc(FL_OBJECT *obj, long val) {
  apiExit();
}

void uiEditPointProc(FL_OBJECT *obj, long val) {
  apiEdit();
}

void uiDeletePointProc(FL_OBJECT *obj, long val) {
  apiDelete();
}

void uiDeleteAllProc(FL_OBJECT *obj, long val) {
  apiDeleteAll();
}

void uiPositionProc(FL_OBJECT *obj, long val) {
  apiPosition();
}

void uiEditLocation(FL_OBJECT *obj, long val) {
  apiEditLocation();
}

void WidgetGeomProc(FL_OBJECT *obj, long val) {
  apiUpdateGeom();
}

void WidgetScaleProc(FL_OBJECT *obj, long val) {
  apiUpdateScale();
}

void uiOptionsDoneProc(FL_OBJECT *obj, long val) {
  fl_hide_form(OptionsForm);
}

/* Things implemented in machine-specific code to be called by common
 * code */
void uiFreeze() {
  fl_deactivate_form(MainForm);
  fl_deactivate_form(OptionsForm);
}

void uiThaw() {
  fl_activate_form(MainForm);
  fl_activate_form(OptionsForm);
}

void uiError(const char *str1, const char *str2, const char *str3) {
  apiFreeze();
  fl_set_object_label(error1, (char *)str1);
  fl_set_object_label(error2, (char *)str2);
  fl_set_object_label(error3, (char *)str3);
  fl_show_form(ErrorForm, FL_PLACE_MOUSE, TRUE, "Warp");
  while (fl_do_forms() != uiErrorOK);
  fl_hide_form(ErrorForm);
  apiThaw();
}

/* The ui code and the api code call one another in a somewhat 
 * convoluted way here. */
void uiEdit(const char *name) {
  FL_OBJECT *obj;
  apiFreeze();
  fl_show_form(EditForm, FL_PLACE_MOUSE, TRUE, (char *)name);
  while (1) {
    obj = fl_do_forms();
    if (obj == uiEditCancel || obj == uiEditSet || obj == uiEditSetAll)
      break;
  }
  if (obj == uiEditSet) apiEditSet();
  else if (obj == uiEditSetAll) apiEditSetAll();
  fl_hide_form(EditForm);
  apiThaw();
}

void uiSetTarget(const char *target) {
  fl_set_input(uiObject, (char *)target);
}

const char *uiGetTarget() {
  return fl_get_input(uiObject);
}

void uiSetCreateOnPick(int val) {
  fl_set_button(uiCreateOnPick, val);
}

int uiGetCreateOnPick() {
  return fl_get_button(uiCreateOnPick);
}

void uiAddWidget(const char *name, int index) {
  if (index < fl_get_browser_maxline(uiPointBrowser))
    fl_insert_browser_line(uiPointBrowser, index, (char *)name);
  else fl_add_browser_line(uiPointBrowser, (char *)name);
}

void uiSetSelectedWidget(int index) {
  fl_select_browser_line(uiPointBrowser, index + 1);
}

int uiGetSelectedWidget() {
  return fl_get_browser(uiPointBrowser) - 1;
}

void uiSetWidgetName(const char *name, int index) {
  fl_replace_browser_line(uiPointBrowser, index + 1, (char *)name);
}

const char *uiGetWidgetName(int index) {
  return fl_get_browser_line(uiPointBrowser, index + 1);
}

int uiWidgetIndex(const char *name) {
  int i;
  for (i = 1; i < fl_get_browser_maxline(uiPointBrowser) + 1; i++)
    if (!strcmp(fl_get_browser_line(uiPointBrowser, i), (char *)name)) 
      return i-1;
  return -1;
}

void uiDeleteWidget(int index) {
  fl_delete_browser_line(uiPointBrowser, index + 1);
}
					
void uiSetStrengthBounds(float min, float max) {
  fl_set_slider_bounds(uiStrength, min, max);
}

void uiSetStrength(float strength) {
  fprintf(stderr, "strength = %f\n", strength);
  fl_set_slider_value(uiStrength, strength);
}

float uiGetStrength() {
  return fl_get_slider_value(uiStrength);
}

void uiSetSmoothnessBounds(float min, float max) {
  fl_set_slider_bounds(uiSmoothness, min, max);
}

void uiSetSmoothness(float smoothness) {
  fprintf(stderr, "smoothness = %f\n", smoothness);
  fl_set_slider_value(uiSmoothness, smoothness);
}

float uiGetSmoothness() {
  return fl_get_slider_value(uiSmoothness);
}

void uiSetPoint(Point3 *pt) {
  flx_set_input_float(uiEditX, pt->x);
  flx_set_input_float(uiEditY, pt->y);
  flx_set_input_float(uiEditZ, pt->z);
}

void uiGetPoint(Point3 *pt) {
  pt->x = flx_get_input_float(uiEditX);
  pt->y = flx_get_input_float(uiEditY);
  pt->z = flx_get_input_float(uiEditZ);
}

void uiSetSteps(int steps) {
  flx_set_input_int(uiIntSteps, steps);
}

int uiGetSteps() {
  return flx_get_input_int(uiIntSteps);
}

void uiSetStart(int start) {
  flx_set_input_int(uiStartStep, start);
}

int uiGetStart() {
  return flx_get_input_int(uiStartStep);
}

void uiSetEnd(int end) {
  flx_set_input_int(uiEndStep, end);
}

int uiGetEnd() {
  return flx_get_input_int(uiEndStep);
}

void uiSetIntToGV(int val) {
  fl_set_button(uiIntToGV, val);
}

int uiGetIntToGV() {
  return fl_get_button(uiIntToGV);
}

void uiSetIntToFiles(int val) {
  fl_set_button(uiIntToFiles, val);
}

int uiGetIntToFiles() {
  return fl_get_button(uiIntToFiles);
}

void uiSetAutoUpdate(int val) {
  fl_set_button(uiAutoUpdate, val);
}

int uiGetAutoUpdate() {
  return fl_get_button(uiAutoUpdate);
}

void uiSetRetain(int val) {
  fl_set_button(uiRetain, val);
}

int uiGetRetain() {
  return fl_get_button(uiRetain);
}

void uiSetPrefix(const char *prefix) {
  fl_set_input(uiPrefix, (char *)prefix);
}

const char *uiGetPrefix() {
  return fl_get_input(uiPrefix);
}

void uiSetPath(const char *path) {
  fl_set_input(uiPath, (char *)path);
}

const char *uiGetPath() {
  return fl_get_input(uiPath);
}

void uiSetWidgetGeom(const char *geom) {
  fl_set_input(uiWidgetGeom, (char *)geom);
}

const char *uiGetWidgetGeom() {
  return fl_get_input(uiWidgetGeom);
}

void uiSetWidgetSize(float size) {
  flx_set_input_float(uiWidgetSize, size);
}

float uiGetWidgetSize() {
  return flx_get_input_float(uiWidgetSize);
}

void uiSetRelativeSize(int val) {
  fl_set_button(uiRelSize, val);
}

int uiGetRelativeSize() {
  return fl_get_button(uiRelSize);
}

void uiSetGridX(int x) {
  flx_set_input_int(uiGridX, x);
}

int uiGetGridX() {
  return flx_get_input_int(uiGridX);
}

void uiSetGridY(int y) {
  flx_set_input_int(uiGridY, y);
}

int uiGetGridY() {
  return flx_get_input_int(uiGridY);
}

void uiSetGridZ(int z) {
  flx_set_input_int(uiGridZ, z);
}

int uiGetGridZ() {
  return flx_get_input_int(uiGridZ);
}
     
