/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef CAMERAP_H
#define CAMERAP_H

#include "camera.h"

#define	CAMMAGIC	0x9c816301

struct Camera {
    REFERENCEFIELDS
    Handle	*c2whandle;	/* Handle for external camtoworld's */
    Transform	camtoworld;	/* this moves the camera to its spot */
    Handle	*w2chandle;	/* Handle for external worldtocam's */
    Transform 	worldtocam;	/* this puts the camera at the origin, etc*/
    int 	flag;		/* perspective?  stereo? */
    float	halfyfield,	/* FOV half-width at z=1 (Y direction) */
    		frameaspect,	/* Aspect ratio, X/Y */
    		focus,		/* Nominal focal distance for perspec<->ortho*/
    		near, far,	/* Near & far clipping distances */
    		stereo_sep,
		stereo_angle;
    Handle	*sterhandle[2];
    Transform	stereyes[2];	/* For stereo separation */
    int		whicheye;	/* Current stereo eye selection */
    int		changed;	/* Mask of "changed" fields, for CamMerge */
    int		space;		/* TM_EUCLIDEAN, TM_HYPERBOLIC, or TM_SPHERICAL */
};

/* bits for 'flag' and 'changed' fields */
#define	CAMF_PERSP		0x01
#define	CAMF_STEREO		0x02
#define	CAMF_NEWC2W		0x04

/* bits for 'changed' only */

#define	CAMF_EYE		0x20
#define	CAMF_STEREOXFORM	0x40
#define	CAMF_STEREOGEOM		0x80
#define	CAMF_W2C		0x100
#define	CAMF_FOV		0x200
#define	CAMF_ASPECT		0x400
#define	CAMF_FOCUS		0x800
#define	CAMF_NEAR		0x1000
#define	CAMF_FAR		0x2000
#define CAMF_SPACE		0x4000

/*
 * routine for updating transforms
 */
void CamTransUpdate(Handle **, Camera *, Transform);

#endif /* !CAMERAP_H */
