#include <stdio.h>
#include <string.h>
#include "forms.h"
#include "formsx.h"

static char buf[FLX_INPUTLEN];

void flx_set_input_printf(FL_OBJECT *obj, char *format, ...) {
  va_list a_list;

  va_start(a_list, format);
  vsprintf(buf, format, a_list);
  fl_set_input(obj, buf);

}

void flx_set_input_float(FL_OBJECT *obj, float f) {
  
  sprintf(buf, "%.2f", f);
  fl_set_input(obj, buf);

}

void flx_set_input_int(FL_OBJECT *obj, int i) {
  
  sprintf(buf, "%d", i);
  fl_set_input(obj, buf);

}

/*
void flx_get_input_scanf(FL_OBJECT *obj, char *format, ...) {
  va_list a_list;

  va_start(a_list, format);
  ----------------- This routine does not seem to exist --------
  vsscanf(fl_get_input(obj), format, a_list);

}
*/

float flx_get_input_float(FL_OBJECT *obj) {
  float f;

  sscanf(fl_get_input(obj), "%f", &f);
  return f;

}

int flx_get_input_int(FL_OBJECT *obj) {
  int i;

  sscanf(fl_get_input(obj), "%d", &i);
  return i;

}

void flx_enable(FL_OBJECT *obj, int lcol) {
  
  obj->active = 1;
  if (lcol == -1) lcol = 0;
  if (lcol != -2) fl_set_object_lcol(obj, lcol);

}

void flx_disable(FL_OBJECT *obj, int lcol) {

  obj->active = 0;
  if (lcol == -1) lcol = 17;
  if (lcol != -2) fl_set_object_lcol(obj, lcol);

}


FL_OBJECT *flx_findobject(FL_FORM *form, char *label) {
  FL_OBJECT *obj;
  obj = form->first;
  while (1) { 
    if (!strcmp(label, obj->label)) return(obj);
    if (obj == form->last) return NULL;
    obj = obj->next;
  }
}




  

