#ifndef HPOINT3DEFS
#define HPOINT3DEFS

typedef float HPt3Coord;
typedef struct { HPt3Coord x, y, z, w; } HPoint3;

extern HPoint3 HPt3Ideal;

extern HPoint3 *HPt3Create();
extern void HPt3Delete(/* HPoint3 *pt */);

extern void HPt3Print(/* HPoint3 *pt */);
extern void HPt3Copy(/* HPoint3 *pt1, *pt2 */);
extern void HPt3From(/* HPoint3 *pt, HPt3Coord x, y, z, w */);
extern int HPt3From3HPl3s(/* HPoint3 *pt, HPlane3 *pl1, *pl2, *pl3 */);

extern void HPt3Pencil(
    /* HPt3Coord t1, HPoint3 pt1, HPt3Coord t2, HPoint3 *pt2, *pt*/);

extern float HPt3DotHPl3(/* HPoint3 *pt, HPlane3 *pl */);

extern void HPt3Normalize(/* HPoint3 *pt1, *pt2 */);

extern int HPt3Undefined(/* HPoint3 *pt */);
extern int HPt3Infinity(/* HPoint3 *pt */);
extern int HPt3Compare(/* HPoint3 *pt1, *pt2 */);

extern int HPt3CoincidentHPt3(/* HPoint3 *pt1, *pt2 */);
extern int HPt3CoincidentHLn3(/* HPoint3 *pt, HLine3 *ln */);
extern int HPt3CoincidentHPl3(/* HPoint3 *pt, HPlane3 *pl */);

extern void HPt3Transform(/* Transform3 T, HPoint3 *pt1, *pt2*/);
extern void HPt3TransformN(/* Transform3 T, HPoint3 *pt1, *pt2, int n*/);

extern float HPt3Distance(/* HPoint3 *pt1, *pt2 */);
extern float HPt3Angle(/* HPoint3 *pt1, *pt2 */);

extern int HPt3IntersectHPt3(/* HPoint3 *pt1, *pt2, HLine3 *ln */);

extern void HPt3Dual(/* HPoint3 *pt, HPlane3 *pl */);
extern void HPt3Perp(/* HPoint3 *pt, HPlane3 *pl */);

#endif
