/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef HPOINTNDEF
#define HPOINTNDEF

#include "reference.h"

typedef float HPtNCoord;
typedef struct HPtN {
	short dim;	/* Dimension, including homogeneous divisor */
	short flags;	/* Space tag */
	HPtNCoord *v;	/* Array of coordinates; v[dim-1] is the homogenous divisor */
} HPointN;


/* N-dimensional transformation matrix.
 * Transforms row vectors (multiplied on the left) of dimension 'idim',
 * yielding row vectors of dimension 'odim'.
 */
typedef struct TmN {
	REFERENCEFIELDS
	short idim, odim;
	short flags;
	HPtNCoord *a;	/* Array of idim rows, odim columns */
} TransformN;

#define	TMNMAGIC	OOGLMagic('T', 1)

/* Refer to the (i,j)'th entry in a TransformN object;
 * beware that (i,j) are not checked!
 */
#define  TmNentry(T, i,j)  ((T)->a[(i)*(T)->odim + (j)])


	/* Construct point */
/*skip*/
extern HPointN *HPtNCreate(int dim, const HPtNCoord *vec);
	/* Destroy point */
/*skip*/
extern void HPtNDelete(HPointN *pt);
	/* Copy point */
extern HPointN *HPtNCopy(const HPointN *pt1, HPointN *pt2);
	/* Sum of points */
extern HPointN *HPtNAdd(const HPointN *pt1, const HPointN *pt2, HPointN *sum);
	/* Space */
/*skip*/
extern int HPtNSpace( const HPointN *pt );
/*skip*/
extern HPointN *HPtNSetSpace( HPointN *pt, int space );

	/* Linear combination */
extern HPointN *HPtNComb(HPtNCoord u, const HPointN *pu, HPtNCoord v, const HPointN *pv, HPointN *sum);

	/* Reduce to unit vector */
extern HPointN *HPtNUnit(const HPointN *from, HPointN *to);

	/* Dehomogenize, returning old 'w' component */
extern HPtNCoord HPtNDehomogenize(const HPointN *from, HPointN *to);

	/* Apply a TransformN to an HPointN */
extern HPointN *HPtNTransform( const TransformN *T, const HPointN *from, HPointN *to );

	/* Add zeros to a vector to make it a given dimension */
extern HPointN *HPtNPad(HPointN *from, short dim, HPointN *to);

	/* Dot product of two vectors */
extern HPtNCoord HPtNDot( const HPointN *p1, const HPointN *p2);

	/* Return index'th component of p . T */
	/* If index is out of range (e.g. -1), return N-1'th component
	 * (i.e. homogeneous divisor).
	 */
extern HPtNCoord *HPtNTransformComponent( const HPointN *p, const TransformN *T, int ncomponents, int *indices, HPtNCoord *results );

#endif
