/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "transform3.h"

/*-----------------------------------------------------------------------
 * Function:	Ctm3Tetrad
 * Description:	concatenate a transform with given columns to the right
 *			of another transform
 * Args:	T: the transform to modify
 *		x: column 1 of right factor
 *		y: column 2 of right factor
 *		z: column 3 of right factor
 *		w: column 4 of right factor
 * Returns:	nothing
 * Author:	hanrahan, mbp
 * Date:	Thu Aug  8 14:54:56 1991
 * Notes:	sets T to T * S, where S is the transform with
 *		  columns x, y, z, w.
 */
void
Ctm3Tetrad( T, x, y, z, w )
    Transform3 T;
    HPoint3 *x, *y, *z, *w;
{
    Transform3 Ta;

    Tm3Tetrad( Ta, x, y, z, w );
    Tm3Concat(Ta, T, T);
}
