/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include <stdio.h>
#include "transform3.h"

/************************************************************************
 * NOTE: we're taking out PostConcat and PreConcat.  They're being left	*
 * here for a short while longer as a memorial.				*
 ************************************************************************/

/*-----------------------------------------------------------------------
 * Function:	Tm3PostConcat
 * Description:	concatenate one transform to another on the right
 * Args:	Ta: left transform	(INPUT & OUTPUT)
 *		Tb: right transform	(INPUT)
 * Returns:	nothing
 * Author:	hanrahan, mbp
 * Date:	Thu Aug  8 13:31:35 1991
 * Notes:	Sets Ta to Ta * Tb.
 */
void
Tm3PostConcat( Ta, Tb )
     Transform3 Ta, Tb;
{
  fprintf(stderr, "WARNING: obsolete function Tm3PostConcat called.  Use\n\
Tm3Concat instead.\n");
  Tm3Concat( Ta, Tb, Ta );
}

/*-----------------------------------------------------------------------
 * Function:	Tm3PreConcat
 * Description:	concatenate one transform to another on the left
 * Args:	Ta: left transform	(INPUT)
 *		Tb: right transform	(INPUT & OUTPUT)
 * Returns:	nothing
 * Author:	hanrahan, mbp
 * Date:	Thu Aug  8 13:31:35 1991
 * Notes:	Sets Tb to Ta * Tb.
 */
void
Tm3PreConcat( Ta, Tb )
    Transform3 Ta, Tb;
{
  fprintf(stderr, "WARNING: obsolete function Tm3PreConcat called.  Use\n\
Tm3Concat instead.\n");
    Tm3Concat( Ta, Tb, Tb );
}




/*-----------------------------------------------------------------------
 * Function:	Tm3Concat
 * Description:	concatenate two transforms
 * Args:	Ta: left factor  (INPUT)
 *		Tb: right factor (INPUT)
 *		Tprod: product (OUTPUT)
 * Returns:	nothing
 * Author:	hanrahan, mbp
 * Date:	Thu Aug  8 13:15:08 1991
 * Notes:	Passing the same transform for either factor and the
 *		product is allowed.
 */
void
Tm3Concat( Ta, Tb, Tprod )
  register Transform3 Ta, Tb, Tprod;
{
  register int i;
  
#define MAKEPRODUCT(T)				\
    for( i=0; i<4; i++ ) {			\
	T[i][0] = Ta[i][0]*Tb[0][0] +		\
		  Ta[i][1]*Tb[1][0] +		\
		  Ta[i][2]*Tb[2][0] +		\
		  Ta[i][3]*Tb[3][0];		\
	T[i][1] = Ta[i][0]*Tb[0][1] +		\
		  Ta[i][1]*Tb[1][1] +		\
		  Ta[i][2]*Tb[2][1] +		\
		  Ta[i][3]*Tb[3][1];		\
	T[i][2] = Ta[i][0]*Tb[0][2] +		\
		  Ta[i][1]*Tb[1][2] +		\
		  Ta[i][2]*Tb[2][2] +		\
		  Ta[i][3]*Tb[3][2];		\
	T[i][3] = Ta[i][0]*Tb[0][3] +		\
		  Ta[i][1]*Tb[1][3] +		\
		  Ta[i][2]*Tb[2][3] +		\
		  Ta[i][3]*Tb[3][3];		\
      }

  if( Ta == Tprod || Tb == Tprod ) {
    Transform3 T;
    MAKEPRODUCT(T);
    memcpy( Tprod, T, sizeof(Transform3) );
  }
  else {
    MAKEPRODUCT(Tprod);
  }

#undef MAKEPRODUCT
}
