/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef TRANSFORMDEFS
#define TRANSFORMDEFS

#include "transform3.h"

typedef Transform3 Transform;
typedef Tm3Coord TmCoord;

#define TmAdjoint Tm3Adjoint
#define TmInvert Tm3Invert
#define TmDeterminant Tm3Determinant
#define TmDual Tm3Dual
#define TmTranspose Tm3Transpose
#define TmPostConcat Tm3PostConcat
#define TmPreConcat Tm3PreConcat
#define TmConcat Tm3Concat
#define TmConjugate Tm3Conjugate

#define TmPrint Tm3Print
#define TmCopy Tm3Copy
#define TmCompare Tm3Compare
#define TmPush Tm3Push
#define TmPop Tm3Pop

#define TmIdentity Tm3Identity
#define TmScale Tm3Scale
#define TmRotateX Tm3RotateX
#define TmRotateY Tm3RotateY
#define TmRotateZ Tm3RotateZ
#define TmRotate Tm3Rotate
#define TmRotateTowardZ Tm3RotateTowardZ
#define TmCarefulRotateTowardZ Tm3CarefulRotateTowardZ
#define TmAlignX Tm3AlignX
#define TmAlignY Tm3AlignY
#define TmAlignZ Tm3AlignZ
#define TmAlign Tm3Align

#define CtmTranslate Ctm3Translate
#define CtmScale Ctm3Scale
#define CtmRotateX Ctm3RotateX
#define CtmRotateY Ctm3RotateY
#define CtmRotateZ Ctm3RotateZ
#define CtmRotate Ctm3Rotate
#define CtmAlignX Ctm3AlignX
#define CtmAlignY Ctm3AlignY
#define CtmAlignZ Ctm3AlignZ
#define CtmAlign Ctm3Align

#define TM_XAXIS TM3_XAXIS
#define TM_YAXIS TM3_YAXIS
#define TM_ZAXIS TM3_ZAXIS
#define TM_IDENTITY TM3_IDENTITY

#define TmTranslate Tm3Translate
#define TmTranslateOrigin Tm3TranslateOrigin
#define TmHypTranslate Tm3HypTranslate
#define TmHypTranslateOrigin Tm3HypTranslateOrigin
#define TmSphTranslate Tm3SphTranslate
#define TmSphTranslateOrigin Tm3SphTranslateOrigin
#define TmSpaceTranslate Tm3SpaceTranslate
#define TmSpaceTranslateOrigin Tm3SpaceTranslateOrigin

#define TmProject Tm3Project
#define CtmProject Ctm3Project
#define TmReflect Tm3Reflect
#define CtmReflect Ctm3Reflect
#define CtmRefract  Ctm3Refract
#define CtmRefract2  Ctm3Refract2
#define TmRefract  Tm3Refract
#define TmRefract2  Tm3Refract2
#define TmSkew Tm3Skew
#define TmShear Tm3Shear
#define TmPerspective Tm3Perspective
#define TmOrthographic Tm3Orthographic
#define TmWindow Tm3Window
#define CtmSkew Ctm3Skew
#define CtmShear Ctm3Shear
#define CtmWindow Ctm3Window
#define CtmPerspective Ctm3Perspective
#define CtmOrthographic Ctm3Orthographic


#endif
