/*
 * plcombine.c
 * author:  Celeste Fowler
 * date:  June 12, 1992
 */
#include <stdlib.h>
#include "polylistP.h"
#include "hpoint3.h"
#include "point3.h"
#include "plutil.h"

static char msg[] = "plcombine.c";

/*
 * PolyList combiner.
 * A minor sideshow.  If a and b differ in some fundamental way in terms
 * of per vertex / per face colors / normals, the colors / normals will
 * be eliminated in the result.  If one polylist is three-d and the other
 * is four-d, the result will be three-d
 */
Geom *PLCombine(Geom *a1, Geom *b1) 
{
  PolyList *a = (PolyList *)a1, *b = (PolyList *)b1;
  int i, j, k;
  HPoint3 *point4;
  ColorA *color, *polycolor;
  Point3 *normal, *polynormal;
  int *vert, nvertices, *nvert;
  Vertex *maxverta = NULL, *maxvertb = NULL;
  Geom *new;
  int flags, fourd = 0;

  if (a == NULL) return(GeomCopy((Geom *)b));
  if (b == NULL) return(GeomCopy((Geom *)a));

  if (strcmp(GeomName(a1), "polylist") || strcmp(GeomName(b1), "polylist"))
    OOGLError(0, "Arguements to PLCombine() not of polylist type.");

  nvertices = a->n_verts + b->n_verts;


  /* Copy points, normals, colors. */
  point4 = (HPoint3 *)OOG_NewE(nvertices * sizeof(HPoint3), msg);
  color = (ColorA *)OOG_NewE(nvertices * sizeof(ColorA), msg);
  normal = (Point3 *)OOG_NewE(nvertices * sizeof(Point3), msg);
  for (i = 0; i < a->n_verts; i++) {
    HPt3Copy(&a->vl[i].pt, &point4[i]);
    bcopy(&a->vl[i].vcol, &color[i], sizeof(ColorA));
    Pt3Copy(&a->vl[i].vn, &normal[i]);
  }
  for (i = 0; i < b->n_verts; i++) {
    HPt3Copy(&b->vl[i].pt, &point4[a->n_verts + i]);
    bcopy(&b->vl[i].vcol, &color[a->n_verts + i], sizeof(ColorA));
    Pt3Copy(&b->vl[i].vn, &normal[a->n_verts + i]);
  }

  /* Create polygons */
  nvert = (int *)OOG_NewE((a->n_polys + b->n_polys) * sizeof(int), msg);
  polycolor = 
    (ColorA *)OOG_NewE((a->n_polys + b->n_polys) * sizeof(ColorA), msg);
  polynormal =
    (Point3 *)OOG_NewE((a->n_polys + b->n_polys) * sizeof(Point3), msg);
  for (i = j = 0; i < a->n_polys; i++) j += a->p[i].n_vertices;
  for (i = 0; i < b->n_polys; i++) j += b->p[i].n_vertices;
  vert = (int *)OOG_NewE(j * sizeof(int), msg);
  for (i = k = 0; i < a->n_polys; i++) {
    nvert[i] = a->p[i].n_vertices;
    bcopy(&a->p[i].pcol, &polycolor[i], sizeof(ColorA));
    Pt3Copy(&a->p[i].pn, &polynormal[i]);
    for (j = 0; j < a->p[i].n_vertices; j++) 
      vert[k++] = a->p[i].v[j] - a->vl;
  }
  for (i = 0; i < b->n_polys; i++) {
    nvert[a->n_polys + i] = b->p[i].n_vertices;
    bcopy(&b->p[i].pcol, &polycolor[a->n_polys + i], sizeof(ColorA));
    Pt3Copy(&b->p[i].pn, &polynormal[a->n_polys + i]); 
    for (j = 0; j < b->p[i].n_vertices; j++)
      vert[k++] = a->n_verts + b->p[i].v[j] - b->vl;
  }

  flags = a->flags;
  fourd = (a->geomflags & VERT_4D) ? 1 : 0;
  
  if ((a->flags & PL_HASVCOL) && !(b->flags & PL_HASVCOL)) {
    if (b->flags & PL_HASPCOL) {
      for (i = 0; i < a->n_polys; i++) 
	bcopy(&a->p[i].v[0]->vcol, &polycolor[i], sizeof(ColorA));
      flags ^= PL_HASVCOL;
      flags |= PL_HASPCOL;
    }
    else for (i = 0; i < b->n_verts; i++) {
      color[a->n_verts + i].r = color[a->n_verts + i].g =
	color[a->n_verts + i].b = 0.15;
      color[a->n_verts + i].a = 1.0;
    } 
  }
  if ((a->flags & PL_HASPCOL) && !(b->flags & PL_HASPCOL)) {
    if (b->flags & PL_HASVCOL) {
      for (i = 0; i < b->n_polys; i++) 
	bcopy(&b->p[i].v[0]->vcol, &polycolor[a->n_polys + i], 
	      sizeof(ColorA));
    }
    else for (i = 0; i < b->n_polys; i++) {
      polycolor[a->n_polys + i].r = polycolor[a->n_polys + i].g = 
	polycolor[a->n_polys + i].b = 0.15;
      polycolor[a->n_polys + i].a = 1.0;
    }
  }
  if (!(flags & PL_HASVCOL) && !(flags & PL_HASPCOL)) {
    if (b->flags & PL_HASPCOL) {
      for (i = 0; i < a->n_polys; i++) {
	polycolor[i].r = polycolor[i].g = polycolor[i].b = 0.15;
	polycolor[i].a = 1.0;
      }
      flags |= PL_HASPCOL;
    }
    if (b->flags & PL_HASVCOL) {
      for (i = 0; i < a->n_verts; i++) {
	color[i].r = color[i].g = color[i].b = 0.15;
	color[i].a = 1.0;
      }
      flags |= PL_HASVCOL;
    }
  }

  if ((a->flags & PL_HASVN) && !(b->flags & PL_HASVN)) flags ^= PL_HASVN;
  if ((a->flags & PL_HASPN) && !(b->flags & PL_HASPN)) flags ^= PL_HASPN;
  if ((a->geomflags & VERT_4D) && !(b->geomflags & VERT_4D)) 
    fourd = 0;

  new = GeomCreate("polylist", 
		   CR_NPOLY, a->n_polys + b->n_polys,
		   CR_POINT4, point4,
		   CR_NORMAL, normal,
		   CR_COLOR, color,
		   CR_NVERT, nvert,
		   CR_VERT, vert,
		   CR_POLYNORMAL, polynormal,
		   CR_POLYCOLOR, polycolor,
		   CR_FLAG, flags,
		   CR_4D, fourd,
		   CR_END);

  OOGLFree(point4);
  OOGLFree(color);
  OOGLFree(normal);
  OOGLFree(nvert);
  OOGLFree(polycolor);
  OOGLFree(polynormal);
  OOGLFree(vert);

  return(new);

}
