/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef	BBOXPDEF
#define BBOXPDEF

#include "geomclass.h"
#include "bbox.h"

/*
 * The vert[] array lists vertices, indexed by binary order of initial axes,
 * where X has weight 1, Y weight 2, Z weight 4.
 * Initially "min" corresponds to 0, "max" to 1.
 * Specifically GeomCreate("bbox", CR_MIN, min, CR_MAX, max) makes a bbox with:
 *  vert[0] = (min.x, min.y, min.z)
 *  vert[1] = (max.x, min.y, min.z)
 *  vert[2] = (min.x, max.y, min.z) ...
 *  vert[7] = (max.x, max.y, max.z).
 * Note this property isn't necessarily preserved if the bbox is transformed.
 */

#define BBOX_P VERT_P
/* we allow BBOX_4D's.  This would be drawn as a hypercube, having
   16 vertices */
#define BBOX_4D VERT_4D

struct BBox {
	GEOMFIELDS
	int             flag;
	HPoint3		min, max;
};

#endif /* ! BBOXPDEF */

