/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/*
 * Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
 * Nathaniel Thurston
 */

#include <stdio.h>
#include "commentP.h"
#include "streampool.h"
#include "handleP.h"

char *
fbalanced(FILE *file)
{
    int depth = 1;
    int bufsize = 10240;
    char fmt[20];
    char *buf = OOGLNewNE(char, bufsize, "Comment data");
    char *bufp = buf;
    if (fexpectstr(file, "{")) return NULL;
    do {
	if (bufp - buf >= bufsize - 2)
	    buf = OOGLRenewNE(char, buf, bufsize += 10240, "Comment data");
	sprintf(fmt, "%%%d[^{}]", bufsize - (bufp - buf) - 2);
	if (fscanf(file, fmt, bufp) > 0)
	    bufp += strlen(bufp);
	switch(*bufp++ = fgetc(file)) {
	    case '}': depth--; break;
	    case '{': depth++; break;
	}
    } while (depth > 0);
    *--bufp = '\0';
    return OOGLRenewNE(char, buf, strlen(buf)+1, "Comment data");
}

Geom *
CommentImport( Pool *p )
{
    char *str;
    register Comment *comment =
	(Comment *)GeomCCreate(NULL, CommentMethods(), NULL);
    FILE *file;
    char *expect;

    if(p == NULL || (file = p->inf) == NULL)
	return NULL;

    if(fexpectstr(file, "COMMENT"))
	return NULL;

    if ((str = ftoken(file, 0)) == NULL) return NULL;
    comment->name = OOGLNewNE(char, strlen(str)+1, "Comment name");
    strcpy(comment->name, str);
    if ((str = ftoken(file, 0)) == NULL) return NULL;
    comment->type = OOGLNewNE(char, strlen(str)+1, "Comment type");
    strcpy(comment->type, str);
    if (fnextc(file, 0) == '{' ) {
      comment->data = fbalanced(file); /* read until '}' */
    } else {
	if (fgetni(file, 1, &comment->length, 0) != 1) return NULL;
	if (comment->length == 0) return NULL;
	if (fexpectstr(file, " ")) return NULL;
	comment->data = OOGLNewNE(char, comment->length, "Comment data");
	if (fread(comment->data, comment->length, 1, file) != 1) return NULL;
    }
    return (Geom *)comment;
}

int
CommentExport( Comment *comment, Pool *pool )
{
    if(comment == NULL || pool == NULL || pool->outf == NULL)
	return 0;

    (void) CommentFSave(comment, pool->outf, "");
    return 1;
}
