/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "discgrpP.h"

GeomClass *DiscGrpClass = NULL;

int DiscGrpPresent = 1;

static char discgrpName[] = "discgrp";

extern DiscGrp      *DiscGrpCreate( va_list );
extern DiscGrp      *DiscGrpDelete( DiscGrp * );
extern DiscGrp      *DiscGrpCopy( DiscGrp * );

extern GeomScanFunc DiscGrpHandleScan;

char *
DiscGrpName()
{
	return discgrpName;
}

GeomClass      *
DiscGrpMethods()
{
	if (!DiscGrpClass)
	{
		DiscGrpClass = GeomClassCreate(discgrpName);

		DiscGrpClass->name = DiscGrpName;
		DiscGrpClass->methods = (GeomMethodsFunc *) DiscGrpMethods;
		DiscGrpClass->create = (GeomCreateFunc *) DiscGrpCreate;
		DiscGrpClass->Delete = (GeomDeleteFunc *) DiscGrpDelete;
		DiscGrpClass->copy = (GeomCopyFunc *) DiscGrpCopy;
		DiscGrpClass->fsave = (GeomFSaveFunc *) DiscGrpFSave;
		DiscGrpClass->bound = (GeomBoundFunc *) DiscGrpBound;
		DiscGrpClass->pick = (GeomPickFunc *) DiscGrpPick;
		DiscGrpClass->draw = (GeomDrawFunc *) DiscGrpDraw;
		DiscGrpClass->scan = (GeomScanFunc *)DiscGrpHandleScan;
		DiscGrpClass->import = (GeomImportFunc *) DiscGrpImport;
/*
		DiscGrpClass->fload = (GeomFLoadFunc *) DiscGrpFLoad;
		DiscGrpClass->evert = (GeomEvertFunc *) DiscGrpEvert;
		DiscGrpClass->transform = 
		  (GeomTransformFunc *) DiscGrpTransform;
		DiscGrpClass->transformto = 
		  (GeomTransformToFunc *) DiscGrpTransformTo;
*/
	}
	return DiscGrpClass;
}
