/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
 * Celeste Fowler */

#include "discgrpP.h"
#include "ooglutil.h"
#include "pickP.h"

DiscGrp *
DiscGrpPick(DiscGrp *dg, Pick *p, Appearance *ap, Transform T)
{
  int elem = 0, pathInd;
  Transform t;
  GeomIter *it;
  Geom *v = NULL;

  if(dg == NULL || dg->geom == NULL)
    return NULL;

  pathInd = VVCOUNT(p->gcur);
  vvneeds(&p->gcur, pathInd + 1);
  VVCOUNT(p->gcur)++;
  it = GeomIterate((Geom *)dg, DEEP);
  while(NextTransform(it, t)) {
    *VVINDEX(p->gcur, int, pathInd) = elem;
    TmConcat(t,T, t);
    if(GeomPick(dg->geom, p, ap, t)) 
      v = (Geom *)dg;
    elem++;
  }
  VVCOUNT(p->gcur)--;
  return v;
}
