/* This file is for managing the output stack of group elements */

#include "discgrpP.h"

	static int BlockSize, array_size;
	static DiscGrpEl *mystack = NULL, *stackptr = NULL;
   	static int count = 0, debug = 0;

int
init_out_stack()
{
    	array_size = 1;
    	BlockSize = 1024;
	count = 0;
    	if ((mystack = OOGLNewN (DiscGrpEl, BlockSize )) == (DiscGrpEl *) NULL) return(0);
	stackptr = mystack;
	return(1);
}
	
int
enumpush(pp)
DiscGrpEl *pp;
{
    register int i;
    if (stackptr >= &mystack[BlockSize*array_size])	{ 
	if (debug) 
	    fprintf(stderr,"allocating again: size is now %d\n",array_size*BlockSize);
	array_size = array_size*2;
        if ((mystack = OOGLRenewN(DiscGrpEl,mystack, array_size*BlockSize)) == (DiscGrpEl *) NULL) return (0);
	stackptr = &mystack[count];
	}
    *stackptr = *pp;
    TmCopy(pp->tform, stackptr->tform); 
    stackptr++;
    count++;
    return(1);
}
    
int
enumgetsize()
{
    return(count);
}

DiscGrpEl *
enumgetstack()
{
    DiscGrpEl *thisptr;
    thisptr = OOGLNewN (DiscGrpEl, count );
    if (thisptr == NULL) return ( (DiscGrpEl *) NULL);
    bcopy(mystack, thisptr, sizeof(DiscGrpEl) * count);
    OOGLFree(mystack);
    return(thisptr);
}
