#include "hpoint3.h"
#include "geomclass.h"
#include "geom.h"
#include "bbox.h"
#include "create.h"

/* Take this out once the create flags are all in the right place */
#include "sphereP.h"

Geom *
GeomBoundSphere(geom, T, space)
     Geom *geom;
     Transform T;
     int space;
{
  Geom *bbox, *sphere;
  HPoint3 minmax[2];

  if (geom && geom->Class->boundsphere) {
    return (*geom->Class->boundsphere) (geom, T==NULL ? TM_IDENTITY : T,
					space);
  }

  bbox = GeomBound(geom, T);
  if (bbox == NULL) return NULL;
  BBoxMinMax((BBox *)bbox, &minmax[0], &minmax[1]);
  GeomDelete(bbox);
  HPt3Normalize(&minmax[0], &minmax[0]);
  HPt3Normalize(&minmax[1], &minmax[1]);

  sphere = GeomCreate("sphere", CR_ENCOMPASS_POINTS, minmax,
		      CR_NENCOMPASS_POINTS, 2, CR_SPACE, space,
		      CR_END);
  if (sphere != NULL && T != NULL) GeomTransform(sphere, T);
  return sphere;
}
