/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
 * Celeste Fowler */

#ifndef PICKPDEF
#define	PICKPDEF

/*
 * Private definitions for picking.
 */

#include "pick.h"
#include "ooglutil.h"

struct Pick {
	Point3 got;

	float thresh;

	int want;		/* Fields wanted */
	int  found;		/* Fields found */

	vvec gcur;              /* Path to the current primitive - 
				   used for recursion */
	vvec gpath;		/* Path to picked primitive */
	Geom *gprim;		/* Picked primitive */

	HPoint3 v;		/* picked vertex, if any */
	int vi;			/* index of picked vertex */

	HPoint3 e[2];		/* endpoints of picked edge, if any */
	int ei[2];		/* indices of endpoints of picked edge */

	Transform Tprim;
	Transform Tmirp;
	Transform Tw;
	Transform Tself;

	HPoint3 *f;		/* array of vertices of picked face, if any */
	int fn;			/* number of vertices in array f */
	int fi;			/* index of picked face */
};

/* 
 * PickFace() is used to test a face for a pick and modify the pick 
 * structure if necessary. 
 *   n_verts is the number of vertices in the face.
 *   verts is the list of vertices in the face.
 *   pick is the pick structure.
 *   ap is the appearance (not currently used).
 * The following fields of the pick structure will be filled in:
 *   found - what has been found.
 *   vi - index of the picked vertex in the verts array.
 *   ei - indices of the endpoints of the picked edge in the verts array.
 *   f - freed if non-NULL and set to NULL
 * PickFace() returns nonzero if something was picked.  The calling 
 * program is responsable for using the data returned in the pick 
 * structure to fill in the actual points and correct the indices.
 */
int PickFace(int n_verts, Point3 *verts, Pick *pick, Appearance *ap);

/*
 * PickFillIn() is used to fill in the fields of a pick structure once
 * a pick has been found.  
 *   pick is the pick structure.
 *   n_verts is the number of points in the face.
 *   got is the interesection of the pick ray with the face.
 *   vertex is the index of the picked vertex (-1 if none).
 *   edge is the index of the first vertex of the hit line (-1 if none).
 *   ep is the picked point on the edge.
 * The routine fills in the following fields of the pick structure:
 *   got - filled in with the parameter got. 
 *   found - filled in with what was found.
 *   vi - the index of the picked vertex. 
 *   ei - the indices of the endpoints of the picked edge. 
 *   f - freed if non-null and set to null.
 *   fn - the number of vertices in the face
 *   gpath - the path to the picked primitive (copy of gcur)
 * The rest of the fields are left unchanged.
 * Returns pick->found.
 */
int PickFillIn(Pick *pick, int n_verts, Point3 *got, int vertex, 
	       int edge, Appearance *ap);


#endif /*PICKPDEF*/
