/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */
static char *copyright = "Copyright (C) 1992 The Geometry Center";

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/*
 * Inst creation, editing, retrieval and deletion.
 */

#include "instP.h"
#include "transobj.h"

void
InstDelete( inst )
    Inst *inst;
{
    if( inst ) {
	if(inst->geom) GeomDelete(inst->geom);
	if(inst->geomhandle) HandlePDelete(&inst->geomhandle);
	if(inst->tlist) GeomDelete(inst->tlist);
	if(inst->tlisthandle) HandlePDelete(&inst->tlisthandle);
	if(inst->axishandle) HandlePDelete(&inst->axishandle);
    }
}

Inst *
InstCopy( Inst *inst ) 
{
  register Inst *ni;

  ni = OOGLNewE(Inst, "InstCopy: Inst");
  GGeomInit(ni, inst->Class, inst->magic, NULL);
  TmCopy(inst->axis, ni->axis);
  ni->geom = GeomCopy(inst->geom);
  ni->geomhandle = NULL;
  ni->tlist = GeomCopy(inst->tlist);
  ni->tlisthandle = NULL;
  ni->axishandle = NULL;
  ni->instflag = inst->instflag;
  ni->seq = inst->seq;
  return(ni);

}

Geom *
InstReplace( register Inst *inst, register Geom *geom )
{
    register Geom *old;

    if(inst == NULL)
	return NULL;

    old = inst->geom;
    inst->geom = geom;
    return old;
}

int
InstGet( register Inst *inst, int attr, register void *attrp )
{
    switch(attr) {
    case CR_GEOM: *(Geom **)attrp = inst->geom; break;
    case CR_GEOMHANDLE: *(Handle **)attrp = inst->geomhandle; break;
    case CR_TLIST: *(Geom **)attrp = inst->tlist; break;
    case CR_TLISTHANDLE: *(Geom **)attrp = (Geom *)inst->tlisthandle; break;
    case CR_AXISHANDLE: *(Handle **)attrp = inst->axishandle; break;
    case CR_AXIS:
	TmCopy(inst->axis, (float (*)[4])attrp);
	return (inst->tlist == NULL && inst->tlisthandle == NULL) ? 1 : 0;
    default:
	return -1;
    }
    return 1;
}

Inst *
InstCreate ( Inst *exist, GeomClass *classp, va_list a_list )
{
    register Inst *inst;
    int attr;
    int fourd = 0;
    int copy = 1;
    float *f;
    Transform *t;
    Geom *g;
    Handle *h;

    if (exist == NULL) {
	inst = OOGLNewE(Inst, "InstCreate inst");
	GGeomInit (inst, classp, INSTMAGIC, NULL);
	TmIdentity(inst->axis);
	inst->instflag = 0;
	inst->geomhandle = NULL;
	inst->geom = NULL;
	inst->tlisthandle = NULL;
	inst->tlist = NULL;
	inst->axishandle = NULL;
    } else {
	/* Check that exist is an inst. */
	inst = exist;
    }

    while (attr = va_arg (a_list, int)) {
	switch(attr) {
	case CR_FLAG:
	    inst->instflag = va_arg(a_list, int);
	    break;

	case CR_GEOMHANDLE:
	    h = va_arg(a_list, Handle *);
	    if(copy) RefIncr((Ref *)h);
	    if(inst->geomhandle)
		HandlePDelete(&inst->geomhandle);
	    inst->geomhandle = h;
	    HandleRegister(&inst->geomhandle, (Ref *)inst, &inst->geom, HandleUpdRef);
	    break;

	case CR_HANDLE_GEOM:
	    h = va_arg(a_list, Handle *);
	    if(copy) RefIncr((Ref*)h);
	    if(inst->geomhandle)
		HandlePDelete(&inst->geomhandle);
	    inst->geomhandle = h;
	    if(h) HandleRegister(&inst->geomhandle,
			(Ref *)inst, &inst->geom, HandleUpdRef);
	    /* Fall into CR_GEOM case */

	case CR_GEOM:
	    g = va_arg(a_list, Geom *);
	    if(copy) RefIncr((Ref *)g);
	    if(inst->geom)
		GeomDelete(inst->geom);
	    inst->geom = g;
	    break;

	case CR_AXIS:
	    t = va_arg(a_list, Transform *);
	    InstTransformTo(inst, (*t));
	    break;

	case CR_AXISHANDLE:
	    h = va_arg(a_list, Handle *);
	    if(copy) RefIncr((Ref *)h);
	    if(inst->axishandle)
		HandlePDelete(&inst->axishandle);
	    inst->axishandle = h;
	    HandleRegister(&inst->axishandle, (Ref *)inst, inst->axis, TransUpdate);
	    break;

	case CR_TLIST:
	    g = va_arg (a_list, Geom *);
	    if(copy) RefIncr((Ref *)g);
	    if(inst->tlist)
		GeomDelete(inst->tlist);
	    inst->tlist = g;
	    break;

	case CR_TLISTHANDLE:
	    h = va_arg(a_list, Handle *);
	    if(copy) RefIncr((Ref *)h);
	    if(inst->tlisthandle != NULL)
		HandlePDelete(&inst->tlisthandle);
	    inst->tlisthandle = h;
	    HandleRegister(&inst->tlisthandle, (Ref *)inst, &inst->tlist, HandleUpdRef);
	    break;

	default:
	    if(GeomDecorate(inst, &copy, attr, &a_list)) {
		OOGLError (0, "InstCreate: Undefined option: %d", attr);
		if(exist == NULL) GeomDelete ((Geom *)inst);
		return NULL;
	    }
	}
    }

    return inst;
}
