/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/*
 * Draw an Inst using the mg library.
 */
#include "instP.h"
#include "mg.h"

Inst *
InstDraw( Inst *inst )
{
    GeomIter *it;
    Transform T;

    it = GeomIterate((Geom *)inst, DEEP);
    while(NextTransform(it, T)) {
	if ( inst->geomflags & VERT_4D )	{
	    if (NextTransform(it, T)) 	{
		DestroyIter(it);
		return NULL;/* Error -- InstDraw on a multi-element 4inst */
		}
	    mgset4to3(inst->axis, inst->seq);
    	    }
	mgpushtransform();
	mgtransform( T );
	GeomDraw( inst->geom );
	mgpoptransform();
    }
    return inst;
}
