#include "geom.h"
#include "create.h"
#include "listP.h"
#include "sphere.h"

Geom *ListBoundSphere(list, T, space)
     List *list;
     Transform T;
     int space;
{
  Geom *carsphere = NULL, *newsphere = NULL, *sphere = NULL;
  register List *l;
  for (l = list; l != NULL; l = l->cdr) {
    carsphere = GeomBoundSphere(l->car, T, space);
    if (carsphere == NULL) continue;
    if (sphere != NULL) {
      SphereUnion3((Sphere *)sphere, (Sphere *)carsphere, (Sphere *)sphere);
      GeomDelete(carsphere);
    }
    else sphere = carsphere;
  }

  return sphere;
}
