/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */
static char *copyright = "Copyright (C) 1992 The Geometry Center";

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "meshP.h"

static tossmesh(Mesh *);
static int meshfield(int copy, int amount,
		void **fieldp, void *value, char *name);

Mesh *
MeshCreate (exist, classp, a_list)
Mesh *exist;
GeomClass *classp;
va_list a_list;
{
    register Mesh *mesh;
    int		attr, copy = 1, fourd = 0;
    int		i;
    int		npts;
    HPoint3	*p;
    Point3 	*n, *u, *p3;
    ColorA	*c;

    p = NULL; n = NULL; u = NULL; c = NULL; p3 = NULL;

    if (exist == NULL) {
	mesh = OOGLNewE(Mesh, "MeshCreate mesh");
	bzero(mesh, sizeof(Mesh));
	GGeomInit (mesh, classp, MESHMAGIC, NULL);
	mesh->flag = 0;
	mesh->nu = 1;
	mesh->nv = 1;
	mesh->umin = -1;
	mesh->umax = -1;
	mesh->vmin = -1;
	mesh->vmax = -1;
    } else {
	/* Check that exist is a Mesh... */
	mesh = exist;
    }

    npts = mesh->nu * mesh->nv;

    while (attr = va_arg (a_list, int)) switch (attr) {
	case CR_FLAG:
	    mesh->flag = va_arg (a_list, int);
	    break;
	case CR_NU:
	    mesh->nu = va_arg (a_list, int);
	    tossmesh(mesh);
	    npts = mesh->nu * mesh->nv;
	    break;
	case CR_NV:
	    mesh->nv = va_arg (a_list, int);
	    tossmesh(mesh);
	    npts = mesh->nu * mesh->nv;
	    break;
	case CR_UMIN:
	    mesh->umin = va_arg (a_list, int);
	    break;
	case CR_UMAX:
	    mesh->umax = va_arg (a_list, int);
	    break;
	case CR_VMIN:
	    mesh->vmin = va_arg (a_list, int);
	    break;
	case CR_VMAX:
	    mesh->vmax = va_arg (a_list, int);
	    break;
	case CR_POINT:
	    if(mesh->p) OOGLFree(mesh->p);
	    mesh->p = OOGLNewNE(HPoint3, npts, "mesh points");
	    p3 = va_arg(a_list, Point3 *);
	    Pt3ToPt4(p3, mesh->p, npts);
	    if(!copy) OOGLFree(p3);
	    break;

	case CR_POINT4:
	    meshfield(copy, npts*sizeof(HPoint3), (void **)&mesh->p,
		(void *)va_arg (a_list, HPoint3 *), "mesh points");
	    break;

	case CR_NORMAL:
	    mesh->flag = (mesh->flag & ~MESH_N) |
		(MESH_N & meshfield(copy, npts*sizeof(Point3),
				(void **)&mesh->n,
				(void *)va_arg (a_list, Point3 *),
				"mesh normals"));
	    break;

	case CR_U:
	    mesh->flag = (mesh->flag & ~MESH_U) |
		(MESH_U & meshfield(copy, npts*sizeof(Point3),
				(void **)&mesh->u,
				(void *)va_arg (a_list, Point3 *),
				"mesh texture coords"));
	    break;

	case CR_COLOR:
	    mesh->flag = (mesh->flag & ~MESH_C) |
		(MESH_C & meshfield(copy, npts*sizeof(ColorA),
				(void **)&mesh->c,
				(void *)va_arg (a_list, ColorA *),
				"mesh colors"));
	    break;

	default:
	    if (GeomDecorate (mesh, &copy, attr, &a_list)) {
		GeomError (0, "MeshCreate: Undefined option: %d", attr);
		OOGLFree (mesh);
		return NULL;
	    }
    }
    /* set submesh dimensions if not otherwise set */
    if (mesh->umin == -1)	mesh->umin = 0;
    if (mesh->umax == -1)	mesh->umax = mesh->nu-1;
    if (mesh->vmin == -1)	mesh->vmin = 0;
    if (mesh->vmax == -1)	mesh->vmax = mesh->nv-1;

    return mesh;
}

static
tossmesh(register Mesh *m)
{
    if(m->p) OOGLFree(m->p);
    if(m->n) OOGLFree(m->n);
    if(m->c) OOGLFree(m->c);
    if(m->u) OOGLFree(m->u);
    if(m->d) OOGLFree(m->d);
    if(m->nd) OOGLFree(m->nd);
    m->p = NULL;
    m->n = NULL;
    m->c = NULL;
    m->u = NULL;
    m->d = NULL;
    m->nd = NULL;
    m->umin = m->umax = m->vmin = m->vmax = -1;
}

static int
meshfield(int copy, int amount, void **fieldp, void *value, char *name)
{
    if(value) {
	if(copy) {
	    if(*fieldp == NULL)
		*fieldp = OOGLNewNE(char, amount, name);
	    memcpy(*fieldp, value, amount);
	} else {
	    if(*fieldp)
		OOGLFree(*fieldp);
	    *fieldp = value;
	}
	return ~0;
    } else {
	if(*fieldp)
	    OOGLFree(*fieldp);
	*fieldp = NULL;
	return 0;
    }
}
