/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include <ctype.h>
#include "meshP.h"

static int
getmeshvert(file, flag, u, v, p, n, c, t)
	FILE	*file;
	register int	flag;
	int	u;
	int	v;
	register HPoint3	*p;
	Point3	*n;
	ColorA	*c;
	Point3	*t;		/* actually u, the texture parameter */
{
	float	inputs[4];
	Point3  p3;
	register int binary = flag&MESH_BINARY;

	if (flag & MESH_Z) {
		p->x = (float) u;
		p->y = (float) v;
		p->w = 1.0;
		if (fgetnf(file, 1, &p->z, binary) <= 0)
			return 0;
	} else if (flag & MESH_4D) {
		if (fgetnf(file, 4, (float *)p, binary) < 4)
			return 0;
	} else 			{
		if (fgetnf(file, 3, (float *)p, binary) < 3)
			return 0;
		p->w = 1.0;
	}

	if (flag & MESH_N && fgetnf(file, 3, (float *)n, binary) < 3)
		return 0;

	if (flag & MESH_C && fgetnf(file, 4, (float *)c, binary) < 4)
		return 0;

	if (flag & MESH_U && fgetnf(file, 3, (float *)t, binary) < 3)
		return 0;

	return 1;
}

static char oldbinary;	/* Old binary format -- has 3-component colors */

static int
getheader(file)
	FILE	*file;
{
	register int c, i, flag;
	static char keys[] = "CNZ4Uuv";
	static short bit[] =
		{ MESH_C, MESH_N, MESH_Z, MESH_4D, MESH_U, MESH_UWRAP, MESH_VWRAP };

	    /* Parse [C][N][Z][4][U][u][v]MESH[ BINARY]\n */
	if(fnextc(file, 0) == '\0') {
	    /* Looks like first byte of magic number of old binary mesh */
	    oldbinary = 1;
	    return(MESH_BINARY);
	}

	oldbinary = 0;
	flag = 0;
	c = fgetc(file);
	for(i = 0; keys[i] != '\0'; i++) {
	    if(c == keys[i]) {
		flag |= bit[i];
		c = fgetc(file);
	    }
	}
	ungetc(c, file);
	if(fexpectstr(file, "MESH"))
	    return(-1);

	if(fnextc(file, 1) == 'B') {
	    if(fexpectstr(file, "BINARY"))
		return(-1);
	    flag |= MESH_BINARY;
	    if(fnextc(file, 1) == '\n')
		(void) fgetc(file);	/* Toss \n */
	}
	return(flag);
}


Mesh *
MeshFLoad(file, fname)
	FILE *file;
	char *fname;
{
	Mesh	m;
	int	n;
	Point3	*p3;
	register int i, u, v;
	int binary;

	if (!file)
		return NULL;

	if((m.flag = getheader(file)) == -1)
		return NULL;

	binary = m.flag & MESH_BINARY;

	if (fgetni(file, 1, &m.nu, binary) <= 0 ||
	    fgetni(file, 1, &m.nv, binary) <= 0) {
	    OOGLSyntax(file,"Reading MESH from \"%s\": expected mesh grid size", fname);
	    return NULL;
	}
	if(m.nu <= 0 || m.nv <= 0 || m.nu > 9999999 || m.nv > 9999999) {
	    OOGLSyntax(file,"Reading MESH from \"%s\": invalid mesh size %d %d",
		fname,m.nu,m.nv);
	    return NULL;
	}

	n = m.nu * m.nv;

	m.p = OOGLNewNE(HPoint3, n, "MeshFLoad: vertices");
	m.n = NULL;
	m.u = NULL;
	m.c = NULL;
	m.d = NULL;
	m.nd = NULL;

	if (m.flag & MESH_N)
	    m.n = OOGLNewNE(Point3, n, "MeshFLoad: normals");
	if (m.flag & MESH_C)
	    m.c = OOGLNewNE(ColorA, n, "MeshFLoad: colors");
	if (m.flag & MESH_U)
	    m.u = OOGLNewNE(Point3, n, "MeshFLoad: texture coords");

	for (i = 0, v = 0; v < m.nv; v++) {
	    for (u = 0; u < m.nu; u++, i++) {
		if(getmeshvert(file, m.flag, u, v,
			&m.p[i], &m.n[i], &m.c[i], &m.u[i]) == 0) {
		    OOGLSyntax(file,
		"Reading MESH from \"%s\": bad element (%d,%d) of (%d,%d)",
			    fname, u,v, m.nu,m.nv);
		    return NULL;
		}
	    }
	}
	return (Mesh *) GeomCCreate (NULL, MeshMethods(), CR_NOCOPY,
		CR_4D, (m.flag & MESH_4D), CR_FLAG, m.flag, CR_NU, m.nu,
		CR_NV, m.nv, CR_POINT4, m.p, CR_COLOR, m.c, CR_NORMAL, m.n,
		CR_U, m.u, NULL);
}
