#include "geom.h"
#include "create.h"
#include "polylistP.h"
#include "sphere.h"

Geom *PolyListSphere(p, T, space)
     PolyList *p;
     Transform T;
     int space;
{
  int i;
  Sphere *sphere;
  HPoint3 spanPts[6];

  if (p == NULL || p->n_verts == 0 || p->n_polys == 0) return NULL;
  sphere = (Sphere *)GeomCreate("sphere", CR_CENTER, &p->vl[0].pt,
				CR_RADIUS, 0.0, CR_AXIS, T, CR_SPACE, space,
				CR_END);
  /* For convenience (if not efficiency) assume all the vertices are 
   * used */
  for (i = 0; i < 6; i++) spanPts[i] = p->vl[0].pt;
  for (i = 0; i < p->n_verts; i++) MaxDimensionalSpan(spanPts, &p->vl[i].pt);
  HPt3TransformN(T, spanPts, spanPts, 6);
  SphereEncompassBounds(sphere, spanPts);
  for (i = 0; i < p->n_verts; i++) 
    SphereAddHPt3(sphere, &p->vl[i].pt, T);
  
  return (Geom *)sphere;
}
						 
