/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */
static char *copyright = "Copyright (C) 1992 The Geometry Center";

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "quadP.h"

Quad *
QuadCreate (exist, classp, a_list)
    Quad *exist;
    GeomClass *classp;
    va_list a_list;
{
    register Quad *quad;
    QuadP *p = (QuadP *)NULL;
    Point3 *p3;
    QuadN *n = (QuadN *)NULL;
    QuadC *c = (QuadC *)NULL;
    int attr;
    int copy = 1, fourd = 0;
    int i,j;

    if (exist == NULL) {
	quad = OOGLNewE(Quad, "QuadCreate: new Quad");
        GGeomInit (quad, classp, QUADMAGIC, NULL);
	quad->flag = quad->maxquad = 0;
        quad->p = (QuadP *)NULL;
        quad->n = (QuadN *)NULL;
        quad->c = (QuadC *)NULL;
    } else {
	/* Check that exist is a Quad. */
	quad = exist;
    }

    while (attr = va_arg(a_list, int))   /* parse argument list */
      switch (attr) {
	case CR_FLAG:
            quad->flag = va_arg(a_list, int);
	    break;

	case CR_NELEM:
	    quad->maxquad = va_arg(a_list, int);
	    break;

	case CR_POINT4:
	    p = va_arg(a_list, QuadP *);
            if (exist) OOGLFree(quad->p);
            if (p == NULL) {
               quad->p = NULL;
               quad->maxquad = 0;
            } else if (copy) {
		quad->p = OOGLNewNE(QuadP,quad->maxquad,"QuadCreate vertices");
		memcpy(quad->p, p, quad->maxquad * sizeof(QuadP));
            } else {
		quad->p = p; /* caller relinquishes ownership of data */
	    }
	    break;

	case CR_POINT:
	    p3 = va_arg(a_list, Point3 *);
            if (exist) OOGLFree(quad->p);
            if (p3 == NULL) {
               quad->p = NULL;
               quad->maxquad = 0;
            } else if (copy) {
		quad->p = OOGLNewNE(QuadP,quad->maxquad,"QuadCreate vertices");
		Pt3ToPt4(quad->p, p3, quad->maxquad * 4);
            } else {
		Pt3ToPt4(quad->p, p3, quad->maxquad * 4);
	    }
	    break;

	case CR_NORMAL:
	    n = va_arg(a_list, QuadN *);
            if (exist && quad->n) OOGLFree(quad->n);
	    if (n == NULL) {
		quad->n = NULL;
            } else if (copy) {
		quad->n = OOGLNewNE(QuadN,quad->maxquad,"QuadCreate normals");
		memcpy(quad->n, n, quad->maxquad*sizeof(QuadN));
            } else
		quad->n = n;
            quad->flag |= QUAD_N;
	    break;

	case CR_COLOR:
	    c = va_arg(a_list, QuadC *);
            if (exist && quad->c) OOGLFree(quad->c);
	    if (c == NULL) {
               quad->c = NULL;
            } else if (copy) {
		quad->c = OOGLNewNE(QuadC, quad->maxquad, "QuadCreate: colors");
		memcpy(quad->c, c, quad->maxquad*sizeof(QuadC));
            }
            else quad->c = c;
            quad->flag |= QUAD_C;
	    break;

	default:
            if (GeomDecorate(quad, &copy, attr, &a_list)) {
	       OOGLError (0, "QuadCreate: Undefined option: %d",attr);
	       if (!exist) GeomDelete((Geom *)quad);
	       return NULL;
            }
      }

    if (quad->p == NULL && quad->maxquad > 0 ||
        quad->p != NULL && quad->maxquad <= 0) {
	OOGLError (0,"QuadCreate: inconsistent number of quads");
	if (!exist) GeomDelete((Geom *)quad);
	return NULL;
    }

    /* compute the value that flag should have */
    if(n == NULL) quad->flag &= ~QUAD_N;
    if(c == NULL) quad->flag &= ~QUAD_C;

    return (Quad *) quad;
}
