/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "quadP.h"
#include "mgP.h"
#include "cmodel.h" 
#include <stdlib.h>
#ifndef alloca
#include <alloca.h>
#endif

Quad *
QuadDraw(register Quad *quad)
{
    int i;

    if (quad == NULL)
      return NULL;

    if (_mgc->space & TM_CONFORMAL_BALL) {
      cmodel_clear(_mgc->space);
      cm_read_quad(quad);
      cmodel_draw(PL_HASVN|PL_HASPN|PL_HASVCOL);
    } else {

      if ((((Quad *)quad)->flag & VERT_N) == 0) {
    	register Appearance *ap = mggetappearance();

	if(ap->valid & APF_NORMSCALE ||
		(ap->flag & APF_FACEDRAW && ap->shading != APF_CONSTANT)) {
	    QuadComputeNormals(quad);
	    quad->flag |= VERT_N;
	}
      }
      if(_mgc->astk->useshader) {
	/*
	 * Special software shading
	 */
	int i, step, lim = quad->maxquad * 4;
	HPoint3 *v = quad->p[0];
	Point3 *n = quad->n[0];
	int cquad = quad->c && !(_mgc->astk->mat.override & MTF_DIFFUSE);
	ColorA *oc = cquad ? quad->c[0] : (ColorA *)&_mgc->astk->mat.diffuse;
	ColorA *c = (ColorA *)alloca(lim * sizeof(ColorA));
	ColorA *tc = c;

	step = (_mgc->astk->ap.shading == APF_SMOOTH) ? 1 : 4;
	for(i = 0; i < lim; i += step) {
	    (*_mgc->astk->shader)(1, v, n, oc, tc);
	    if(cquad) oc += step;
	    if(step == 4) {
		tc[1] = *tc;
		tc[2] = *tc;
		tc[3] = *tc;
		v += 4;  n += 4;  tc += 4;
	    } else {
		v++; n++; tc++;
	    }
	}
	mgquads( quad->maxquad, quad->p, quad->n, c );
      } else {
	/*
	 * Ordinary shading
	 */
	mgquads( quad->maxquad, quad->p, quad->n, quad->c );
      }
    }

    return quad;
}
