#include <stdio.h>
#include <string.h>
#include "geom.h"
#include "geomclass.h"
#include "transform.h"
#include "sphereP.h"

Sphere *SphereFLoad(file, fname) 
     FILE *file;
     char *fname;
{
  int ch;
  HPoint3 center;
  float radius;
  Geom *sphere;
  int space;
  int i;

  if (file == NULL) return NULL;

  space = TM_EUCLIDEAN;

  (void) fnextc(file, 0);     /* Skip white space and comments */
  

  i = fgetc(file);
  if (i == 'E') {
    space = TM_EUCLIDEAN;
    if (fexpectstr(file, "SPHERE")) return NULL;
  }
  else if (i == 'H') {
    space = TM_HYPERBOLIC;
    if (fexpectstr(file, "SPHERE")) return NULL;
  }
  else if (i == 'S') {
    i = fgetc(file);
    if (i == 'S') {
      space = TM_SPHERICAL;
      i = fgetc(file);
    }
    if (i != 'P' || fexpectstr(file, "HERE")) return NULL;
  }
  else return NULL;
  
  if ( fgetnf(file, 1, &radius, 0) != 1 ) {
    return NULL;
  }

  if ( fgetnf(file, 3, &center.x, 0) != 3 ) {
    return NULL;
  }
  center.w = 1.0;

  sphere = GeomCreate("sphere", CR_RADIUS, (double)radius, 
		      CR_CENTER, &center, CR_SPACE, space, CR_END);

  return (Sphere *)sphere;
}
