/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

 /*
  * Geometry Routines
  * 
  * Geometry Supercomputer Project
  * 
  * ROUTINE DESCRIPTION:
  *	Draw a Vect (collection of vectors).
  * 
  */

#include "mgP.h"
#include "vectP.h"
#include "hpointn.h"
#include "transformn.h"

#include <stdlib.h>
#ifndef alloca
#include <alloca.h>
#endif

static void
draw_projected_vect(mgmapfunc NDmap, void *NDinfo, Vect *v, int flags, int penultimate)
{
    HPointN *h = HPtNCreate(5, NULL);
    HPoint3 *p, *op, *np, *newp;
    ColorA *lastcolor, *c, *newc;
    int i, nc, hascolor, colored = 0;

    newp = (HPoint3 *)alloca(v->nvert*sizeof(HPoint3));
    newc = (ColorA *)alloca(v->nvert*sizeof(ColorA));

    for(i = 0, op = v->p, np = newp; i < v->nvert; i++, op++, np++) {
	*(HPoint3 *)h->v = *op;
	colored = (*NDmap)(NDinfo, h, np, &newc[i]);
    }

    for(i = 0, p = newp, c = colored ? newc : v->c; i < v->nvec; i++) {
	register int nv;

	nv = vcount(v->vnvert[i]);
	if(colored) nc = nv;
	else if (hascolor) nc = v->vncolor[i];

	flags |= vwrapped(v->vnvert[i]);

	if(nc==0)
	    if(lastcolor)
		mgpolyline(nv,p,1,lastcolor, flags);
	    else
		mgpolyline(nv,p,nc,c,flags);
	else
	    mgpolyline(nv,p,nc, lastcolor=c, flags);

	p += nv;
	if (hascolor) c += nc;
	flags = (i < penultimate) ? 6 : 2;	/* 2: not first batch member */
    }
    HPtNDelete(h);
}

Vect *
VectDraw(v)
     register Vect *v;
{
	register HPoint3 *p;
	register ColorA *c, edgecolor;
	register int n, hascolor, nc;
	int flags, penultimate;
	ColorA *lastcolor=NULL;
	register Appearance *ap = mggetappearance();

	/* Don't draw if vect-drawing is off. */
	if (v == NULL || (ap->flag & APF_VECTDRAW) == 0)
	    return NULL;
	
	/* draw in conformal model if necessary */
	if (_mgc->space & TM_CONFORMAL_BALL) {
            cmodel_clear(_mgc->space);
            cm_read_vect(v);
            cmodel_draw(0);
	    return v;
	}
 
	p = v->p;
	c = v->c;
	hascolor = (v->ncolor > 0) &&
		!(ap->mat && (ap->mat->override & MTF_EDGECOLOR));

	if (!hascolor && ap->mat) {
	  *(Color *)&edgecolor = ap->mat->edgecolor;
	  edgecolor.a = 1;
	  c = &edgecolor;
	  nc = 1;
	}

	flags = v->nvec > 1 ? 4 : 0; 	/* 4: not last mbr of batch of lines */
	penultimate = v->nvec - 2;

	if(_mgc->NDinfo) {
	    Transform T;
	    float focallen;
	    mgpushtransform();
	    CamGet(_mgc->cam, CAM_FOCUS, &focallen);
	    TmTranslate(T, 0., 0., -focallen);
	    TmConcat(T, _mgc->C2W, T);
	    mgsettransform(T);
	    draw_projected_vect(_mgc->NDmap, _mgc->NDinfo, v, flags, penultimate);
	    mgpoptransform();
	    return v;
	}

	for(n = 0; n < v->nvec; n++) {
	    register int nv;

	    nv = vcount(v->vnvert[n]);
	    if (hascolor) nc = v->vncolor[n];


	    flags |= vwrapped(v->vnvert[n]);

	    if(nc == 0)
		if(lastcolor)
		    mgpolyline(nv, p, 1, lastcolor, flags);
		else
		    mgpolyline(nv, p, nc, c, flags);
	    else
		mgpolyline(nv,p,nc,lastcolor=c, flags);

	    p += nv;
	    if (hascolor) c += nc;
	    flags = (n < penultimate) ? 6 : 2;	/* 2: not first batch member */
	}
	return v;
}

