
#import <appkit/appkit.h>
#import <appkit/graphics.h>
#import <dpsclient/wraps.h>

#include "mgriP.h"

/* The MGView class is the class which handles drawing */
@interface MGView:View
{
    mgricontext *theContext;
}
- (BOOL)canBecomeMainWindow;
- (BOOL)canBecomeKeyWindow;
- windowDidResize:sender;
- windowWillClose:sender;
- windowDidExpose:sender; /* nonretained windows */
- windowWillMiniaturize:sender toMiniwindow:miniwindow;
- windowDidDeminiaturize:sender;
- windowDidBecomeKey:sender;
- windowDidBecomeMain:sender;
- drawSelf:(NXRect *)r :(int)c;

@end

@implementation MGView

- (BOOL)canBecomeMainWindow
{
  return YES;
}

- (BOOL)canBecomeKeyWindow
{
  return YES;
}

- windowDidResize:sender
{
    int xsize, ysize;
    mgricontext *thectx =  (mgricontext *)mgri_findctx((char *)sender );

    [window display];
    
    if(thectx!=NULL && thectx->callback!=NULL) {
    	thectx->callback(thectx, MG_RIWINDOWRESIZED);
    }
    return self;
}

- windowWillClose:sender
{
    mgricontext *thectx = (mgricontext *)mgri_findctx((char *)sender );
    if(thectx!=NULL && thectx->callback!=NULL) {
        thectx->dying=1;
    	thectx->callback(thectx, MG_RIWINDOWCLOSED);
	
    }
    return self;
}

- windowWillMiniaturize:sender toMiniwindow:miniwindow
{
    mgricontext *thectx =  (mgricontext *)mgri_findctx((char *)sender );
    if(thectx!=NULL && thectx->callback!=NULL) {
    	thectx->callback(thectx, MG_RIWINDOWICONIFIED);
    }
    return self;
}

- windowDidDeminiaturize:sender
{
    mgricontext *thectx =  (mgricontext *)mgri_findctx((char *)sender );
    if(thectx!=NULL && thectx->callback!=NULL) {
    	thectx->callback(thectx, MG_RIWINDOWDEICONIFIED);
    }
    return self;
}

- windowDidExpose:sender
{
    /* for use with non-retained windows. Is this valid? */
    mgricontext *thectx =  (mgricontext *)mgri_findctx((char *)sender );
    if(thectx!=NULL && thectx->callback!=NULL) {
    	thectx->callback(thectx, MG_RIWINDOWEXPOSED);
    }
    return self;
}

- windowDidBecomeKey:sender
{
    mgricontext *thectx =  (mgricontext *)mgri_findctx((char *)sender );
    if(thectx!=NULL && thectx->callback!=NULL) {
    	thectx->callback(thectx, MG_RIWINDOWBECAMEKEY);
    }
    return self;
}

- windowDidBecomeMain:sender
{
    mgricontext *thectx =  (mgricontext *)mgri_findctx((char *)sender );
    if(thectx!=NULL && thectx->callback!=NULL) {
    	thectx->callback(thectx, MG_RIWINDOWBECAMEMAIN);
    }
    return self;
}

- drawSelf:(NXRect *)r :(int)c
{
  register ColorA *bg;
  bg=&_mgc->background;
  PSsetrgbcolor(bg->r, bg->g, bg->b);
  NXRectFill(&bounds);
  return self;
}

@end

int
mgri_nxwindow(int x, int y, int xs, int ys, char *name,
	      int noborder, unsigned int *globalNum)
{
    NXRect r, win;
    NXPoint mgvorigin;
    id dwindow, dview;
    
    /* if the window already exists, return */
    if(_mgric->nxwindow) return 0;
    
    r.origin.x = x;
    r.origin.y = y;
    r.size.width = xs;
    r.size.height = ys;
    
    /* check for application object */
    if(NXApp==NULL) {
        /* we must create an 'application' object */
	/* this creates a connection with the window server */
        NXApp = [Application new];
	_mgric->standalone = 1;
    } else _mgric->standalone = 0;

    /* create the window */
    dwindow = (id)_mgric->nxwindow = (char *)[[Window alloc]
    	initContent:&r
	style:noborder ? NX_PLAINSTYLE : NX_RESIZEBARSTYLE
	backing:NX_BUFFERED
	buttonMask:NX_CLOSEBUTTONMASK
		   |NX_MINIATURIZEBUTTONMASK
	defer:NO];

    /* following used to create window resource */
    NXConvertWinNumToGlobal([dwindow windowNum], globalNum);

    r.origin.x = 0;
    r.origin.y = 0;
        
    dview = (id)_mgric->nxview = (char *)[[MGView alloc] initFrame:&r];
    [(id)_mgric->nxview allocateGState]; /* for faster (un)lockfocus */
    
    [[(id)_mgric->nxwindow contentView] addSubview:(id)_mgric->nxview];
    mgvorigin.x = 0;
    mgvorigin.y = r.size.height;
    [(id)_mgric->nxview convertPoint:&mgvorigin toView:nil];
    [(id)_mgric->nxwindow getFrame:&win];
    mgvorigin.y = win.size.height - mgvorigin.y;
    _mgric->mgvorigin[0] = (int)mgvorigin.x;
    _mgric->mgvorigin[1] = (int)mgvorigin.y;
    [(id)_mgric->nxwindow setDelegate:(id)_mgric->nxview];
    [(id)_mgric->nxwindow addToEventMask:NX_LMOUSEDRAGGEDMASK];
    [(id)_mgric->nxwindow addToEventMask:NX_RMOUSEDRAGGEDMASK];
    [(id)_mgric->nxwindow addToEventMask:NX_RMOUSEDOWNMASK];
    [(id)_mgric->nxwindow addToEventMask:NX_RMOUSEUPMASK];

    [[(id)_mgric->nxwindow contentView]  setAutoresizeSubviews:YES];
    [(id)_mgric->nxview setAutosizing:NX_WIDTHSIZABLE|NX_HEIGHTSIZABLE];
    [(id)_mgric->nxwindow setTitle:(const char *)name];
    [(id)_mgric->nxwindow display];
    //[(id)_mgric->nxwindow makeKeyAndOrderFront:(id)_mgric->nxwindow];
    return 1;
}


// MUST INCLUDE CONTEXT ON THIS ONE - CAN'T USE CURRENT CONTEXT!
void
mgri_closewindow(mgricontext *thectx)
{
    /* 
     * we must check to see if the window is 'dying', which
     * means the user is closing the window from the title
     * bar & we are in the middle of the windowWillClose method
     * so the window must stick around & will be closed later
     * by the appkit
     */
    if(!thectx->dying) {
	[(id)thectx->nxwindow performClose:(id)0];
    }
}

void
mgri_display()
{
    [(id)_mgric->nxview display];
}

void
mgri_getnxrect(float *f)
{
    NXRect theRect;
    [(id)_mgric->nxview getFrame:&theRect];
    // Convert camera view's frame from superview to window coords.
    [[(id)_mgric->nxview superview] convertRect:&theRect toView:nil];
    f[0]=theRect.origin.x;
    f[1]=theRect.origin.y;
    f[2]=theRect.size.width;
    f[3]=theRect.size.height;
}

void
mgri_clear()
{
  register ColorA *bg;
  register Color *eg;
  NXRect bounds;
  bg=&_mgc->background;
  [(id)_mgric->nxview lockFocus];
  [(id)_mgric->nxview getBounds:&bounds];
  PSsetrgbcolor(bg->r, bg->g, bg->b);
  NXRectFill(&bounds);
  [(id)_mgric->nxview unlockFocus];
  NXPing();
}

void
mgri_flush()
{
    [(id)_mgric->nxwindow flushWindow];
}

void mgri_processevents()
{
    NXEvent theEvent;
    while(DPSGetEvent(DPSGetCurrentContext(), &theEvent, NX_ALLEVENTS,
    	0.0, NX_BASETHRESHOLD))
	{
	    [NXApp sendEvent:&theEvent];
	}
}

void
mgri_errorhandler(RtInt type, RtInt severity, char *message,
                  RtToken routine, RtToken context)
{
    /* Warnings and Info are ignored. We could just ignore those
       troublesome warnings such as clip plane and anisometric xform, eh? */
       
    if(severity==2) {
        fprintf(stderr,"MGRI: QRMAN reports RIE_ERROR. type:%d message:%s\n",type,message);
	return;
    }
    if(severity==3) {
        fprintf(stderr,"MGRI: QRMAN reports RIE_SEVERE. type:%d message:%s\n",type,message);
	fprintf(stderr,"SUGGEST TERMINATION!\n");
    }
}

void mgri_startdebugcontext()
{
    /* if the context does not exists, create it */
    if(!_mgric->debugContext) {
	_mgric->debugContext = RiBegin(NULL, NULL);
	RiHider(RI_HIDDEN,RI_NULL);
        _mgric->debugResource = RiResource("File", RI_ARCHIVE, RI_NULL);
    }
	
}

void mgri_stopdebugcontext()
{
}

void mgri_debugcontext()
{
    /* toggel debug context */
    if(_mgric->debug) _mgric->debug = 0;
    else _mgric->debug = 1;
}

