#include "ooglutil.h"
#include "geom.h"
#include "quadP.h"
#include "pointlistP.h"

void *quad_PointList_get(int sel, Geom *geom, va_list args);
void *quad_PointList_fillin(int sel, Geom *geom, va_list args);
void *quad_PointList_set(int sel, Geom *geom, va_list args);
void *quad_PointList_length(int sel, Geom *geom, va_list args);

#define MAX_METHODS 4

static SpecFunc methods[] = {
  "PointList_get", quad_PointList_get,
  "PointList_fillin", quad_PointList_fillin,
  "PointList_set", quad_PointList_set,
  "PointList_length", quad_PointList_length
};

static char msg[] = "ptlQuad.c";

ptlQuad_init() {
  pointlist_initspec(methods, MAX_METHODS, GeomClassLookup("quad"));
}


void *quad_PointList_get(int sel, Geom *geom, va_list args) {
  HPoint3 *plist;
  Quad *q = (Quad *)geom;
  float **t;

  plist = OOGLNewNE(HPoint3, q->maxquad * 4, msg);
  t = va_arg(args, float **);
  return GeomCall(GeomMethodSel("PointList_fillin"), geom, t, 0, plist);
}


void *quad_PointList_fillin(int sel, Geom *geom, va_list args) {
  int i;
  Quad *q = (Quad *)geom;
  float **t;
  HPoint3 *plist;
  
  t = va_arg(args, float **);
  va_arg(args, int);
  plist = va_arg(args, HPoint3 *);

  for (i = 0; i < q->maxquad; i++)
    bcopy(q->p[i], &plist[i * 4], 4 * sizeof(HPoint3));
  HPt3TransformN(t, plist, plist, q->maxquad * 4);
  return plist;
}

void *quad_PointList_set(int sel, Geom *geom, va_list args) {
  int i;
  HPoint3 *plist;
  Quad *q = (Quad *)geom;
  
  va_arg(args, int);
  plist = va_arg(args, HPoint3 *);
  for (i = 0; i < q->maxquad; i++)
    bcopy(&plist[i * 4], q->p[i], 4 * sizeof(HPoint3));
  return((void *)q);
}


void *quad_PointList_length(int sel, Geom *geom, va_list args) {
  Quad *q = (Quad *)geom;
  return((void *)(q->maxquad * 4));
}

