//
//  GlobeViewPart.m
//
//  Ron Blanford, TRW Inc., October 1991.
//

#import "GlobeViewPart.h"
#import "Thinker.h"
#import <appkit/NXImage.h>
#import <appkit/Panel.h>
#import <c.h>
#import <libc.h>
#import <math.h>
#import <defaults.h>
#import <sys/file.h>

@implementation GlobeView

- oneStep
{
    BStimeval now = currentTimeInMs();

    if (now > GSNextRotationTime)
    {
	if (++currentFrame >= numberOfFrames) currentFrame = 0;
	image = [imageList objectAt:currentFrame];
	GSNextRotationTime = now + 1000/framesPerSecond;
    }

    return [super oneStep];
}


char *basename(char *path, char *suffix)
{
    char *begin, *end, *name;
    int len;
    
    if (strlen(path) < strlen(suffix)) {
        end = begin = path;
    }
    else {
	begin = rindex(path, '/');
	if (begin) begin++;
	    else begin = path;
    
	end = path+strlen(path)-strlen(suffix);
	if (0 != strcmp(end, suffix))
	    end = path+strlen(path);
    
	if (end < begin) end = begin;
    }
    len = end-begin;
    name = malloc(len+1);
    strncpy(name, begin, len);
    name[len] = '\0';
    return name;
}


static BOOL noAnimFile = FALSE;

- initFrame:(NXRect *)frameRect
{
    char appDirectory[1024], *lastSlash;
    const char *animSpeed, *animFile, *animName;
    char animFrame[1024];
    int i, f;
    id local_image;

    [super initFrame:frameRect];
    
    animSpeed = NXGetDefaultValue([NXApp appName], "animSpeed");
    if (animSpeed == NULL) framesPerSecond = 18;
	else framesPerSecond = atoi(animSpeed);

    animFile = NXGetDefaultValue([NXApp appName], "animFile");
    if (animFile == NULL) {
	strcpy(appDirectory, NXArgv[0]);
	lastSlash = rindex(appDirectory, '/');
	strcpy((lastSlash?lastSlash+1:appDirectory), "Globe.anim");
	animFile = appDirectory;
    }
    animName = basename(animFile, ".anim");
    
    imageList = [[List alloc] init];

    /* construct the image list */
    for (i=0; ; i++) {
        sprintf(animFrame, "%s/%s.%d.tiff", animFile, animName, i+1);
	if (!(local_image = [NXImage findImageNamed:animFrame]))
	{
	    if ((f=open(animFrame, O_RDONLY)) < 0) break;
		close(f);
	    //printf("Loading %s\n", animFrame);
	    local_image = [[NXImage alloc] initFromFile:animFrame];
	    if (local_image == NULL) break;	// never null, even if no file
	    [local_image setName:animFrame];
	}
	//else printf("Using existing %s\n", animFrame);
        [imageList addObject:local_image];
    }
    numberOfFrames = i;
    currentFrame = 0;
    
    if (numberOfFrames == 0) {
        if (!noAnimFile)
	    NXRunAlertPanel([NXApp appName], "Could not open %s",
				NULL, NULL, NULL, animFile);
	noAnimFile = TRUE;
        return NULL;
    }
    
    // Tell SlidingImageView about the image size
    [super setImage:[imageList objectAt:0]];

    GSNextRotationTime = 0;
    return self;
}

// override this method so that Thinker can't set the default image.
- setImage:newImage
{
    return self;
}


@end
