/* $Id: global.h,v 1.4 1992/03/02 16:25:28 jtsillas Exp $ */

/*****************************************************************************
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *  Copyright 1990 Thomson Consumer Electronics, Inc.
 *  Copyright 1991 Bull HN Worldwide Info Systems, Inc.
 *
 *****************************************************************************/

/*  global.h:
 *
 *    Contain extern declarations of variables and functions.
 */

#include "defs.h"

/* mxgdb.c */

extern Widget toplevel;

/* callgdb.c */

void callgdb(int, char**);
char *callxtty(void);
extern char *xttyname;
extern char gdbtty[];

/* command.c */

void Break(Widget, XtPointer, XtPointer);
void DoIt(Widget, XtPointer, XtPointer);
void XttyCallback(Widget, XtPointer, XtPointer);
void Print(Widget, XtPointer, XtPointer);
void Display_(Widget, XtPointer, XtPointer);
void Undisplay(Widget, XtPointer, XtPointer);
void Clear(Widget, XtPointer, XtPointer);
void Quit(Widget, XtPointer, XtPointer);
void Help(Widget, XtPointer, XtPointer);
void PopupSearch(Widget, XtPointer, XtPointer);
void send_command(char*);
char *get_command(void);
void insert_command(char*);
void delete_command(void);
void CreateSearchPopup(Widget);

/* gdb.c */
void debug_init(void);
void ReadGdbCallback(XtPointer, 
		     int*, XtInputId*);
void write_gdb(char*);
void query_gdb(char*);
void read_from_gdb(void);

/* dialog.c */

void CreateDialogWindow(Widget);
void AppendDialogText(char*);

extern Widget dialogWindow;

/* filemenu.c */

void File(Widget, XtPointer, XtPointer);
void OKCallBack(Widget, XtPointer, XtPointer);
void CancelCallBack(Widget, XtPointer, XtPointer);

/* handler.c */

void TextSetTopPosition();
void AdjustText();
void func_handler();
void stop_at_handler();
void stop_in_handler();
void file_handler();
void use_handler();

/* gdb_handler.c */

void exec_handler(char*, int);
void done_handler(char*, int);
void updown_handler(void);
void clear_handler(void);
void debug_handler(void);
void cd_handler(char*);
void pwd_handler(char*);
void search_handler(void);
void list_handler(void);
void display_handler(void);
void help_handler(char*, char*);
void display_info_handler(int);
void break_handler(void);
void info_dir_handler(void);
void directory_handler(void);
void info_line_handler(void);
void info_break_handler(char*);
void frame_curr_handler(void);
void source_handler(void);
void query_gdb_echo(char*);

extern Widget		helplabels[];
extern Widget		helpbuttons[];

/* parser.c */

int match(PatternRec*, char*, int);
void parser_init(void);

/* gdb_parser.c */

void parse(char*, char*);
void filter(char*, char*, char*);
int gdb_source_command(char*, int);
int gdb_define_command(char*, FILE*);

/* signals.c */

void trap_signals(void);

/* signs.c */

void signs_init(void);
void DisplayStop(FileRec*, int);
void UpdateStops(FileRec*);
void ClearStops(void);
void RemoveStop(int);
void UpdateArrow(FileRec*);
void UpdateUpdown(FileRec*);
void UpdateBomb(FileRec*);

/* source.c */

void Update(Widget, XEvent*, String*, Cardinal*);
void source_init(void);
void CreateSourceWindow(Widget);
int LoadCurrentFile(void);
char *GetPathname(char*);
void PopupCommands(Widget, XtPointer, XmPushButtonCallbackStruct*);
void MakeDirList(char*);
int LoadFile(char*);
void UpdateScrollV(FileRec*);
extern Widget commandDialog, sourceForm, sourceWindow, sourceBBW, scrollV;

/* utils.c */

int TextPositionToLine(XmTextPosition);
int LineToStop_no(int);
void bell(int);
char *concat(char*, char*);
#ifndef SYSV
char *strstr(const char *, const char *);
#endif

/* windows.c */

void CreateSubWindows(Widget);
void UpdateFileLabel(char*);
void UpdateFunctionLabel(char*);
void UpdateLineLabel(Cardinal);
void UpdateMessageWindow(char*, char*);

extern Widget displayWindow, fileSel, displayFD, helpFD,
  helpselectscroll, helpupbutton, helpupbuttonlabel;

/* extern variables */

extern Display	*display;
extern XtAppContext 	app_context;
extern MxgdbResources app_resources;
extern char	mxgdbinit[];
extern char	*gdbprompt;
extern char	*mxgdbprompt;
extern Boolean	Tstartup;
#ifdef DEBUG
extern Boolean	debug;
#endif

extern FileRec   	*displayedFile;
extern Tokens		Token;
extern PatternRec       dataPattern[];

extern Boolean 	Echo;
extern Boolean	Prompt;
extern Boolean	Parse;
extern Boolean	FalseSignal;
extern int	gdbpid;
#ifdef STR_PTY
extern FILE	*gdbfpin;
extern FILE	*gdbfpout;
#else
extern FILE	*gdbfp;
#endif
extern int      xttypid;

extern char 	CurrentFile[];
extern char 	cwd[];

extern Arrow arrow;
extern Updown updown;
extern Stops stops[];
extern Bomb bomb;
extern Cardinal nstops;
extern ArrowSign arrowsign[];
extern UpdownSign updownsign[];
extern StopSign stopsign[];
extern BombSign bombsign[];


