/* Implementation of ButtonCell class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang (SLAC)
 *	    Fred Harris (Hawaii)
 *	    Mike Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for window system
 *
 * ButtonCell.m,v 1.56 1994/07/16 17:04:39 pfkeb Exp
 */

#include "ButtonCell.h"

#include "NXBundle.h"
#include <objc2/hashtable.h>
#include <stdlib.h>
#include <string.h>

extern char	*ButtonCellInstanceName( void );


@implementation ButtonCell:ActionCell

/* initialization */

- init
{
    [super init];
    instancename = ButtonCellInstanceName();
    [self _init];
    return self;
}

- copy
{
    ButtonCell	*newCell;

    newCell = [super copy];
    [newCell setIcon:icon];
    return newCell;
}

- setIcon:(const char *)iconName
{
    icon = NXCopyStringBuffer(iconName);
    return self;
}

- (const char *)icon
{
    return icon;
}

	/* Archiving methods */

- read:(TypedStream*)typedStream
/* If this is the buttoncell of a popuplist, then 
        the flag read from the stream indicates whether
	the popuplist exists or not.
 */
{
    int		flag;
    NXBundle	*bundle;
    char 	buffer[MAXPATHLEN+1];
    int	localState;

    [super read:typedStream];
    objc_read_type(typedStream, "i", &popup);
    if (popup) {
	objc_read_object(typedStream, &target);
    }
    objc_read_type(typedStream, "i", &flag);
    if ( flag ) {
#ifdef DEBUG
	fprintf(stderr, "before BC\n");
#endif
        objc_read_type(typedStream, "*", &icon);
#ifdef DEBUG
	fprintf(stderr, "after BC\n");
#endif
	bundle = [NXBundle bundleForClass:[self class]];
	if ( [bundle getPath:buffer forResource:icon ofType:"xbm"]) {
	    iconFile = NXCopyStringBuffer(buffer);
	}
     }
    objc_read_type(typedStream, "i", &flag);
    if ( flag ) {
        objc_read_type(typedStream, "*", &altIcon);
	bundle = [NXBundle bundleForClass:[self class]];
	if ( [bundle getPath:buffer forResource:altIcon ofType:"xbm"]) {
	    altIconFile = NXCopyStringBuffer(buffer);
	}
    }
    objc_read_type(typedStream, "i", &flag);
    if ( flag ) {
    	objc_read_type(typedStream, "i", &localState);
    }
    
    // very questionable
    [super setState:localState];
    
    return self;
}

- awake
{
    [super awake];
    
    widgetType = 0;
    
    /* should be moved to _init maybe? */
    if(icon) { 
    	if (!strcmp(icon, "NXradio")) widgetType = NXRADIO;
    	else if (!strcmp(icon, "NXswitch")) widgetType = NXSWITCH;
    }
    
    [self _init];
    
    if (!popup) {
        [self _setPopUp];
    }
    
    return self;
}

- setStringValue:(const char *)aString
{
    [super setStringValue:aString];
    [self _setStringValue:aString];
    return self;
}

- (const char *)title
{
    return [super stringValue];
}

- setTitle:(const char *)aString
{
    return [self setStringValue:aString];
}

- setState:(int)value
{
  /* give widget chance to detect change of state by calling it first */
    [self _setState:value];
    [super setState:value];
    return self;
}

- setKeyEquivalent:(unsigned short)charCode
{
    keyEquivalent = charCode;
    return self;
}

- _setMode:(int)aMode
{
    radioBehavior = aMode;
    return self;
}

- performClick:sender
{
    [self sendAction];
    return self;
}

- (int)_radioType
{
    return radioBehavior;
}

@end
