/* Interface for CustomObject class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors:  Paul Kunz and Imran Qureshi
 *
 * This file is part of an Objective-C class library for a window system
 *
 * CustomObject.h,v 1.4 1994/06/15 18:57:34 pfkeb Exp
 */


#include <objc/Object.h>

/* Add an archiving category to object so every object can respond to
   -nibInstantiate
*/
@interface Object (XmArchiving)
-nibInstantiate;
@end

 /*----------------------------------*/
/* This are interfaces for NeXT Custom Objects */
@interface CustomObject:Object
{
  char	*realClassName;
  id    realObject;
  id    extension;

   BOOL   amAwake;
}
- init;
- write:(TypedStream *) stream;
- read:(TypedStream *) stream;
- awake;
- nibInstantiate;

@end


