/* Implementation of MList class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * MList.m,v 1.32 1994/06/25 01:11:36 pfkeb Exp
 */

/* Implementation Note:  This non-OpenStep class is used as
 * temporary replacement for a matrix of SelectionCells.  It will
 * be eliminated later
 */
 
#include "MList.h"

/* Required for implementation: */
#include "Motif.h"
#include <Xm/List.h>
#include <Xm/TextF.h>
#include "coll/List.h"
#include "ActionCell.h"
#include "Matrix.h"
#include <stdlib.h>             /* for free()   */

#define CELL_HEIGHT 16

static void
click(Widget w, XtPointer client_data, XtPointer call_data)
{
    MList *listid = (MList *)client_data;
    XmListCallbackStruct *cb = (XmListCallbackStruct *) call_data;

    switch (cb->reason) {
      case XmCR_BROWSE_SELECT:
         [[listid target] perform:[listid action] with:listid]; 
         break;
      case XmCR_DEFAULT_ACTION:
         [[listid target] perform:[listid doubleAction] with:listid];
         break; 
      default:
         break;
    }
}

@implementation MList 

- initFrame:(const NXRect *)frameRect
{
    [super initFrame:frameRect];
    instancename = "MList";
    classname = xmListWidgetClass;
    return self;
}

- fillListFrom:(Matrix *)aMatrix
{
    Cell	*aCell;
    List	*list;
    XmString	*items;
    char	*string;
    int		i, count;

    [self empty];
    if ( widgetid ) {
	XtUnmanageChild(widgetid);
	XtDestroyWidget(widgetid);
    }
    widgetid = NULL;
    list = [aMatrix cellList];
    count = [list count];
    items = (XmString *)malloc( count*sizeof(XmString *) );
    for ( i = 0; i < count; i++ ) {
	aCell = [list objectAt:i];
	string = (char *)[aCell stringValue];
	items[i] = XmStringCreate(string, XmSTRING_DEFAULT_CHARSET);
    }
    frame.origin.x = frame.origin.y = 0;
    frame.size.height = count * CELL_HEIGHT + 0.4 * CELL_HEIGHT;
    [self _addArg:XmNwidth  :(void *)frame.size.width];
    [self _addArg:XmNheight :(void *)frame.size.height];
    [self _addArg:XmNitems :(void *)items];
    [self _addArg:XmNitemCount :(void *)count];
    [self _addArg:XmNvisibleItemCount :(void *)count];
    if ( [superview _widget] ) {
	[self _managedBy:superview];
	i = count;
	while ( i-- ) {
	    XmStringFree( items[i] );
	}
	free( items );
    }
    return self;
}

- empty
{
    if ( widgetid ) {
	XmListDeleteAllItems(widgetid);
    }
    return self;
}

- getSelectedCells:(List *)aList from:(Matrix *)cellMatrix
{
    Cell	*aCell;
    List	*selList;
    int 	*position_list, position_count;
    int		i, pos;
    Boolean	flag;
    
    if ( aList ) {
        selList = aList;
    } else {
        selList = [[List alloc] init];
    }
    flag = XmListGetSelectedPos(widgetid, &position_list, &position_count); 
    if ( flag == FALSE ) 
        return selList;
    for ( i = 0; i < position_count; i++ ) {
        pos = position_list[i] -1;
	aCell = [cellMatrix cellAt:pos :0];
	[selList addObject:aCell];
    }
    return selList;
}


- selectCellAt:(int)row
{
    XmListSelectPos ( widgetid, row+1, False );
    return self;
}

- setTarget:anObject
{
    target = anObject;
    return self;
}

- target
{
    return target;
}

- setAction:(SEL)aSelector
{
    action = aSelector;
    return self;
}

- (SEL)action
{
    return action;
}

- setDoubleAction:(SEL)aSelector
{
    doubleAction = aSelector;
    return self;
}

- (SEL)doubleAction
{
    return doubleAction;
}

-free
{
    [self empty];
    return [super free];
}

- _addCallback
{
    XtAddCallback(widgetid, XmNbrowseSelectionCallback, 
                     click, (XtPointer)self);
    XtAddCallback(widgetid, XmNdefaultActionCallback,
                     click, (XtPointer)self);
    return self;
}

- _managedBy:parent wid:(void*)widget
{
    int temp = 500;
    
    [self _addArg:XmNdoubleClickInterval:(void *)temp];
    [self _addArg:XmNshadowThickness :(void *)0];
    [super _managedBy:parent wid:widget];
    return self;
}
@end
