/* Interface for MenuCell class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, and Libing Wang
 *
 * This file is part of an Objective-C class library a window system
 *
 * MenuCell.h,v 1.22 1994/06/15 18:58:14 pfkeb Exp
 */

#ifndef _MenuCell_h_
#define _MenuCell_h_


#include "ButtonCell.h"

@class Menu;
@interface MenuCell:ButtonCell
{
    Menu    *subMenu;
    SEL	    updateAction;
}


- init;
- copy;
- free;

- (BOOL)hasSubmenu;
- setSubmenu:aMenu;

- setUpdateAction:(SEL)aSelector forMenu:aMenu;
- setState:(int) value;
- (SEL)updateAction;

- read:(TypedStream *)typedStream;
- write:(TypedStream *)typedStream;

@end

@interface MenuCell(WidgetSet)
- _init;
- _addCallback;
- _setSubmenu;
- _managedBy:parent;
- _managedBy:parent wid:(void*)widget;
@end

#endif /* _MenuCell_h_ */
