/* Implementation of NXBrowserCell class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Paul Kunz and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * NXBrowserCell.m,v 1.9 1994/06/11 03:56:25 pfkeb Exp
 */

#include "NXBrowserCell.h"

@implementation NXBrowserCell:Cell

// + branchIcon;
// + branchIconH;

- init
{
    [super init];
    instancename = "NXBrowserCell";
    return self;
}

// - initTextCell:(const char *)aString;
// - free;

- (BOOL) isLeaf
{
    return _isLeaf;
}

- setLeaf:(BOOL) aFlag
{
    _isLeaf = aFlag;
    return self;
}

- (BOOL) isLoaded
{
    return _isLoaded;
}

- setLoaded:(BOOL)aFlag
{
    _isLoaded = aFlag;
    return self;
}

// - reset;
// - set;
// - setImage:newImage;
// - image;
// - setAltImage:newAltImage;
// - altImage;
// - (BOOL)isOpaque;
// - calcCellSize:(NXSize *)theSize inRect:(const NXRect *)aRect;
// - drawInside:(const NXRect *)cellFrame inView:controlView;
// - drawSelf:(const NXRect *)cellFrame inView:controlView;
// - highlight:(const NXRect *)cellFrame inView:controlView lit:(BOOL)lit;

// + new;
// + newTextCell;
// + newTextCell:(const char *)aString;

/* Methods not in NeXTStep */

- copy
{
    NXBrowserCell	*newCell;

    newCell = [super copy];
    [newCell   setLeaf:_isLeaf];
    [newCell setLoaded:_isLoaded];
    return newCell;
}

- _managedBy:parent
{
    return self;
}
@end
