/* Implementation of OpenPanel class
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Jeff Kamerer
 *
 * This file is part of an Objective-C class library for a window system
 *
 */

#include "OpenPanel.h"

#include <stdio.h>
#include <stdlib.h>             
#include "Application.h"
#include "TextField.h"

@implementation OpenPanel

- initContent:(const NXRect *)contentRect style:(int)aStyle
	backing:(int)backingType buttonMask:(int)mask defer:(BOOL)flag
{
	[super initContent:contentRect style:aStyle backing:backingType
		buttonMask:mask defer:flag];
	instancename = "OpenPanel";

	[_titleText setStringValue:"Open"];

	return self;
}

- ok:sender
{
	FILE *theFile = NULL;
	const char *formString = [form stringValue];
	char *aFilename =
		malloc((strlen(directory) + strlen(formString) + 2) * sizeof(char));

	if (formString[0] == '\0') {
		return self;
	}
	strcpy(aFilename, directory);
	strcat(aFilename, "/");
	strcat(aFilename, formString);
	if 	(!(theFile = fopen(aFilename, "r" ))) {
		fclose(theFile);
		free(aFilename);
		[form selectText:self];
		return self;
	}
	strcpy(filename, aFilename);
	free(aFilename);
	fclose(theFile);
	[self performClose:self];
	[NXApp stopModal:NX_OKTAG];
	return self;
}

- allowMultipleFiles:(BOOL)flag
{
    _allowMultipleFiles = flag;
    return self;
}

- (int)runModalForDirectory:(const char *)path file:(const char *)name 
                                  types:(const char *const *)fileTypes
{
  /* need to set resources first, then */
    return [self runModal];
}

- (int)runModalForTypes:(const char *const *)fileTypes
{
 /* Need to add handling of file selector's filters */
   return [self runModal];  
}

- (int)runModalForDirectory:(const char *)path file:(const char *)name
{
  /* Needs to set the widget resources, then */
    return [self runModal];
}

@end
