/* Interface for Panel class
 *
 * Copyright (C)  1993, 1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Panel.h,v 1.14 1994/07/26 23:40:43 kamerer Exp
 */

 
#ifndef _Panel_h_
#define _Panel_h_

#include "Window.h"

extern int 
NXRunAlertPanel(const char *title, const char *msg, const char *defaultButton, 
                const char *alternateButton, const char *otherButton, ...);

// extern int 
// NXRunLocalizedAlertPanel(const char *table, const char *title, 
//                          const char *msg, const char *defaultButton, 
//                          const char *alternateButton, 
//                          const char *otherButton, ...);

extern id 
NXGetAlertPanel(const char *title, const char *msg, const char *defaultButton, 
                const char *alternateButton, const char *otherButton, ...);

extern void NXFreeAlertPanel(id panel);

/*
 * NXRunAlertPanel() return values (also returned by runModalSession: when
 * the modal session is run with a panel returned by NXGetAlertPanel()).
 */

#define NX_ALERTDEFAULT		1
#define NX_ALERTALTERNATE	0
#define NX_ALERTOTHER		-1
#define NX_ALERTERROR		-2

/* Tags for common controls in Panels */

#define NX_OKTAG	1
#define NX_CANCELTAG	0


@interface Panel:Window
{
}
- initContent:(const NXRect *)contentRect style:(int)aStyle 
	backing:(int)bufferingType buttonMask:(int)mask defer:(BOOL)flag;
- init;
// - (BOOL)commandKey:(NXEvent *)theEvent;
// - keyDown:(NXEvent *)theEvent;

- (BOOL)isFloatingPanel;
- setFloatingPanel:(BOOL)flag;
- (BOOL)doesBecomeKeyOnlyIfNeeded;
- setBecomeKeyOnlyIfNeeded:(BOOL)flag;

// - (BOOL)worksWhenModal;
// - setWorksWhenModal:(BOOL)flag;

// + newContent:(const NXRect *)contentRect style:(int)aStyle 
//      backing:(int)bufferingType buttonMask:(int)mask defer:(BOOL)flag;
// + new;

/* The following not in NextStep */

- initContent:(const NXRect *)contentRect;
- awake;

@end

#endif
