/* Implemenation of Panel class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Panel.m,v 1.13 1994/07/26 23:40:45 kamerer Exp
 */


#include "Panel.h"

@implementation Panel:Window

- initContent:(const NXRect *)contentRect style:(int)aStyle
	backing:(int)bufferingType buttonMask:(int)mask defer:(BOOL)flag
{
	return [self initContent:contentRect];
}

- initContent:(const NXRect *)contentRect 
{
    [super initContent:contentRect];
    wFlags.isPanel = YES; 
    wFlags.dontFreeWhenClosed = YES;   
    return self;
}

- init
{
    NXRect  defaultRect = { {0, 0}, {20, 20} };
            
    [self initContent:&defaultRect];
    return self;
}

- awake
{
    [super awake];
    return self;
}
// - (BOOL)commandKey:(NXEvent *)theEvent;
// - keyDown:(NXEvent *)theEvent;

- (BOOL)isFloatingPanel
{
    return _floatingPanel;
}

- setFloatingPanel:(BOOL)flag
{
    _floatingPanel = flag;
    return self;
}

- (BOOL)doesBecomeKeyOnlyIfNeeded
{
    return _limitedBecomeKey;
}

- setBecomeKeyOnlyIfNeeded:(BOOL)flag
{
    _limitedBecomeKey = flag;
    return self;
}

// - (BOOL)worksWhenModal;
// - setWorksWhenModal:(BOOL)flag;

@end
