/* Interface for SavePanel class
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Jeff Kamerer
 *
 * This file is part of an Objective-C class library for a window system
 *
 */

#ifndef _SavePanel_h_
#define _SavePanel_h_

#include "Panel.h"

@interface SavePanel : Panel
{
	id form;
	id browser;
	id okButton;
//	id accessoryView;
//	id separator;
	char *filename;
	char *directory;
	const char **filenames;
	char *requiredType;
//	struct _spFlags {
//		unsigned int  opening:1;
//		unsigned int  exitOk:1;
//		unsigned int  allowMultiple:1;
//		unsigned int  dirty:1;
//		unsigned int  invalidateMatrices:1;
//		unsigned int  filtered:1;
//	}	spFlags;
//	unsigned short directorySize;
	
	id _cancelButton;
	id _formLabel;
	id _titleText;
	id _beenUsed;
	char *_directoryAsSeen;	/* path with the DIR_INDICATORs in it */
}

+ newContent:(const NXRect *)contentRect style:(int)aStyle
	backing:(int)bufferingType buttonMask:(int)mask defer:(BOOL)flag;

- init;
- initContent:(const NXRect *)contentRect style:(int)aStyle
	backing:(int)backingType buttonMask:(int)mask defer:(BOOL)flag;

- (int)runModal;
- (int)runModalForDirectory:(const char *)path file:(const char *)filename;

- cancel:sender;
- ok:sender;

- (const char *)filename;
- (const char *)directory;
- setDirectory:(const char *)path;
- setPrompt:(const char *)prompt;
- setTitle:(const char *)aTitle;
- (const char *)requiredFileType;
- setRequiredFileType:(const char *)type;

- setAccessoryView:aView;

@end

@interface SavePanel(delegateMethods)
- (int)browser:sender fillMatrix:matrix inColumn:(int)column;
- highlighted:sender;
- clickOK:sender;
@end

#endif  /* _SavePanel_h_ */
