/* Interface for SliderCell class
 *
 * Copyright (C)  1993, 1994  The Board of Trustees of
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * SliderCell.h,v 1.15 1994/06/19 20:25:12 pfkeb Exp
 */

#ifndef _Slidercell_h_
#define _Slidercell_h_

#include "ActionCell.h"

@interface SliderCell : ActionCell
{
	double 	maxValue;
	double  minValue;
	double  value;
	int	vert;	// vertical or not... for archiving
	BOOL	wasDragged;	
}

// + (BOOL)prefersTrackingUntilMouseUp;

- init;
// - awake;

- (double)minValue;
- setMinValue:(double)aDouble;
- (double)maxValue;
- setMaxValue:(double)aDouble;

// - setAltIncrementValue:(double)incValue;
// - (double)altIncrementValue;

- (int)isVertical;
- (const char *)stringValue;
- setStringValue:(const char *)aString;
- (int)intValue;
- setIntValue:(int)anInt;
- (float)floatValue;
- setFloatValue:(float)aFloat;
- (double)doubleValue;
- setDoubleValue:(double)aDouble;

// - setContinuous:(BOOL)flag;
// - (BOOL)isContinuous;
// - (BOOL)isOpaque;
// - calcCellSize:(NXSize *)theSize inRect:(const NXRect *)aRect;
// - setTitleGray:(float)grayVal;
// - (float)titleGray;
// - setTitleColor:(NXColor)newColor;
// - (NXColor)titleColor;
// - setTitleFont:fontObj;
// - titleFont;
// - (const char *)title;
// - setTitle:(const char *)aString;
// - setTitleNoCopy:(const char *)aString;
// - setTitleCell:aCell;
// - titleCell;
// - setEnabled:(BOOL)flag;
// - setKnobThickness:(NXCoord)aFloat;
// - (NXCoord)knobThickness;
// - setImage:backgroundImage;
// - image;
// - getKnobRect:(NXRect*)knobRect flipped:(BOOL)flipped;
// - drawKnob:(const NXRect*)knobRect;
// - drawKnob;
// - drawBarInside:(const NXRect *)aRect flipped:(BOOL)flipped;
// - drawSelf:(const NXRect *)cellFrame inView:controlView;
// - drawInside:(const NXRect *)cellFrame inView:controlView;
// - (BOOL)startTrackingAt:(const NXPoint *)startPoint inView:controlView;
// - (BOOL)continueTracking:(const NXPoint *)lastPoint 
//                       at:(const NXPoint *)currentPoint inView:controlView;
// - stopTracking:(const NXPoint *)lastPoint 
//             at:(const NXPoint *)stopPoint inView:controlView
//      mouseIsUp:(BOOL)flag;
// - (BOOL)trackMouse:(NXEvent *)theEvent 
//             inRect:(const NXRect *)cellFrame ofView:controlView;
// in category - write:(TypedStream *)ts;
- read:(NXTypedStream *)stream;

/* 
 * The following method is obsolete.  
 */
// + new;


/* non-NeXTSTEP methods */
- copy;
- setVertical:(BOOL)flag;

@end

#endif
