/* Implemenation of SliderCell class
 *
 * Copyright (C)  1993, 1994  The Board of Trustees of
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * SliderCell.m,v 1.16 1994/06/19 20:25:14 pfkeb Exp
 */

#include "SliderCell.h"

#include <stdlib.h>
#include <string.h>
#include <objc2/typedstream2.h>

extern char * SliderCellInstanceName(void);

@interface SliderCell(WidgetSet)
- _init;
- _setMinValue;
- _setMaxValue;
- _setValue;
- (double)_value;
- _setVertical:(BOOL)flag;
- (int)_isVertical;
- _addCallback;
- _managedBy:parent wid:(void *)widget;
@end

@implementation SliderCell : ActionCell

// + (BOOL)prefersTrackingUntilMouseUp

- init
{
	[super init];
	[self _init];
	instancename = SliderCellInstanceName();
	return self;
}

// - awake

- (double)minValue
{
    return minValue;
}

- setMinValue:(double)aDouble
{
    minValue = aDouble;
    [self _setMinValue];
    return self;
}

- (double)maxValue
{
    return maxValue;
}

- setMaxValue:(double)aDouble
{
    maxValue = aDouble;
    [self _setMaxValue];
    return self;
}

// - setAltIncrementValue:(double)incValue
// - (double)altIncrementValue

- (int)isVertical
{
    return [self _isVertical];;
}

- (const char *)stringValue
{
    float f;
    char *temp;
    
    f = [self floatValue];
    temp = (char *)malloc(sizeof(float)*2);
    sprintf(temp, "%f", f);
    return temp;
}

- setStringValue:(const char *)str
{
    double f;
    
    f = atof(str);
    if (f) [self setDoubleValue:f];
    return self;
}

- (int)intValue
{
    int intValue;
    
    intValue = [self _value];;
    return intValue;
}

- setIntValue:(int)anInt
{
    value = anInt;
    [self _setValue];
    return self;
}

- (float)floatValue
{
    float	f;
    
    f = [self _value];
    return f;
}

- setFloatValue:(float)aFloat
{
    value = (double)aFloat;
    [self _setValue];
    return self;
}

- (double)doubleValue
{
    value = [self _value];
    return value;
}

- setDoubleValue:(double)aDouble
{
    value = aDouble;
    [self _setValue];
    return self;
}

// - setContinuous:(BOOL)flag;
// - (BOOL)isContinuous;
// - (BOOL)isOpaque;
// - calcCellSize:(NXSize *)theSize inRect:(const NXRect *)aRect;
// - setTitleGray:(float)grayVal;
// - (float)titleGray;
// - setTitleColor:(NXColor)newColor;
// - (NXColor)titleColor;
// - setTitleFont:fontObj;
// - titleFont;
// - (const char *)title;
// - setTitle:(const char *)aString;
// - setTitleNoCopy:(const char *)aString;
// - setTitleCell:aCell;
// - titleCell;
// - setEnabled:(BOOL)flag;
// - setKnobThickness:(NXCoord)aFloat;
// - (NXCoord)knobThickness;
// - setImage:backgroundImage;
// - image;
// - getKnobRect:(NXRect*)knobRect flipped:(BOOL)flipped;
// - drawKnob:(const NXRect*)knobRect;
// - drawKnob;
// - drawBarInside:(const NXRect *)aRect flipped:(BOOL)flipped;
// - drawSelf:(const NXRect *)cellFrame inView:controlView;
// - drawInside:(const NXRect *)cellFrame inView:controlView;
// - (BOOL)startTrackingAt:(const NXPoint *)startPoint inView:controlView;
// - (BOOL)continueTracking:(const NXPoint *)lastPoint 
//                       at:(const NXPoint *)currentPoint inView:controlView;
// - stopTracking:(const NXPoint *)lastPoint 
//             at:(const NXPoint *)stopPoint inView:controlView
//      mouseIsUp:(BOOL)flag;
// - (BOOL)trackMouse:(NXEvent *)theEvent 
//             inRect:(const NXRect *)cellFrame ofView:controlView;
// in category - write:(TypedStream *)ts;

- read:(TypedStream *)ts
{
    int a, b, c;
    [super read:ts];
    objc_read_float(ts, &a);
    objc_read_float(ts, &b);
    objc_read_float(ts, &c);
    objc_read_type(ts, "i", &vert);
    value = (double)a;
    maxValue = (double)b;
    minValue = (double)c;
    
    [self init];
    [self setMaxValue:maxValue];
    [self setMinValue:minValue];
    [self _setVertical:vert];
    return self;
}


/* The following method is obsolete. */
// + new;

/* The following methods are not in NeXTSTEP/OpenStep */

- copy
{
    SliderCell	*newCell;
    
    newCell = [super copy];
    [newCell setMaxValue:maxValue];
    [newCell setMinValue:minValue];
    [newCell setDoubleValue:value];
    return newCell;
}

- setVertical:(BOOL)flag
{
    [self _setVertical:flag];
    return self;
}

@end
