/* Interface for View class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * View.h,v 1.63 1994/08/17 05:11:16 fxmlk Exp
 */

 
#ifndef _View_h_
#define _View_h_

#include "Responder.h"
#include "graphics.h"
#include "Motif.h"	/* for XEvent */

/* Are we drawing, printing, or copying PostScript to the scrap? */

extern short NXDrawingStatus;

/* Autosizing parameters */

#define       NX_NOTSIZABLE           (0)
#define       NX_MINXMARGINSIZABLE    (1)
#define       NX_WIDTHSIZABLE         (2)
#define       NX_MAXXMARGINSIZABLE    (4)
#define       NX_MINYMARGINSIZABLE    (8)
#define       NX_HEIGHTSIZABLE        (16)
#define       NX_MAXYMARGINSIZABLE    (32)
 
/* NXDrawingStatus values */

#define NX_DRAWING	1	/* we're drawing */
#define NX_PRINTING	2	/* we're printing */
#define NX_COPYING	3	/* we're copying to the scrap */


@class List, Pasteboard, Window;

@interface View:Responder
{
    NXRect 	frame;
    NXRect 	bounds;
    View        *superview;
    List   	*subviews;
    Window	*window;
    struct __vFlags {
	unsigned int        noClip:1;
	unsigned int        translatedDraw:1;
	unsigned int        drawInSuperview:1;
	unsigned int        alreadyFlipped:1;
	unsigned int        needsFlipped:1;
	unsigned int        rotatedFromBase:1;
	unsigned int        rotatedOrScaledFromBase:1;
	unsigned int        opaque:1;
	unsigned int        disableAutodisplay:1;
	unsigned int        needsDisplay:1;
	unsigned int        validGState:1;
	unsigned int        newGState:1;
	unsigned int        _RESERVED:2;
	unsigned int        _noVerticalAutosizing:1;
	unsigned int        _hasDirtySubview:1;
    } vFlags;
    struct ___vFlags {
	unsigned int        autosizing:6;
	unsigned int        autoresizeSubviews:1;
	unsigned int        notifyWhenFlipped:1;
	unsigned int        ancestorNotifyWasEnabled:1;
	unsigned int        needsAncestorNotify:1;
	unsigned int        notifyToInitGState:1;
	unsigned int        wantsGState:1;
	unsigned int        noCopyOnScroll:1;
	unsigned int        noDisplayOnScroll:1;
	unsigned int        specialClip:1;
	unsigned int        mark:1;
    } vFlags2;
    float	frameAngle;
    int		_gstate;
    BOOL	focusLocked;	
}

- init;
- initFrame:(const NXRect *)frameRect;
- free;
- superview;
- subviews;
- (BOOL)isDescendantOf:aView;
- findAncestorSharedWith:aView;
- opaqueAncestor;
- addSubview:aView;
- addSubview:aView :(int)place relativeTo:otherView;
- windowChanged:newWindow;
- replaceSubview:oldView with:newView;
- removeFromSuperview;
 
- notifyAncestorWhenFrameChanged:(BOOL)flag;
- suspendNotifyAncestorWhenFrameChanged:(BOOL)flag;
- notifyWhenFlipped:(BOOL)flag;
- descendantFlipped:sender;
- scrollPoint:(const NXPoint *)aPoint;
- scrollRectToVisible:(const NXRect *)aRect;
- autoscroll:(NXEvent *)theEvent;
- (BOOL)calcUpdateRects:(NXRect *)rects :(int *)rectCount
                 :(NXRect *)enclRect :(NXRect *)goodRect;
- invalidate:(const NXRect *)rects :(int)rectCount;
- scrollRect:(const NXRect *)aRect by:(const NXPoint *)delta;
- moveTo:(NXCoord)x :(NXCoord)y;
- rotateTo:(NXCoord)angle;
- moveBy:(NXCoord)deltaX :(NXCoord)deltaY;
- rotateBy:(NXCoord)deltaAngle;

- setDrawSize:(NXCoord)width :(NXCoord)height;
- setDrawRotation:(NXCoord)angle;
- translate:(NXCoord)x :(NXCoord)y;
- scale:(NXCoord)x :(NXCoord)y;
- rotate:(NXCoord)angle;
- getBounds:(NXRect *)theRect;
- (float)boundsAngle;
- setFlipped:(BOOL)flag;
- (BOOL)isFlipped;
- (BOOL)isRotatedFromBase;
- (BOOL)isRotatedOrScaledFromBase;
- setOpaque:(BOOL)flag;
- (BOOL)isOpaque;
- (BOOL)canDraw;
- setAutodisplay:(BOOL)flag;
- (BOOL)isAutodisplay;
- setNeedsDisplay:(BOOL)flag;
- (BOOL)needsDisplay;
- (BOOL)lockFocus;
- unlockFocus;
- (BOOL)getVisibleRect:(NXRect *)theRect;
- displayIfNeeded;
- display:(const NXRect *)rects :(int)rectCount :(BOOL)clipFlag;
- displayFromOpaqueAncestor:(const NXRect *)rects :(int)rectCount
      :(BOOL)clipFlag;
- display;
- drawSelf:(const NXRect *)rects :(int)rectCount;
- adjustScroll:(NXRect *)newVisible;

- read:(TypedStream*)typedStream;
- write:(NXTypedStream *)stream;
- awake;
- awakeFromNib;
- window;
- getFrame:(NXRect *)theRect;
- (float)frameAngle;
- setDrawOrigin:(NXCoord)x :(NXCoord)y;
- setFrame:(const NXRect *)frameRect;
- convertPointFromSuperview:(NXPoint *)aPoint;
- convertPointToSuperview:(NXPoint *)aPoint;
- convertRectFromSuperview:(NXRect *)aRect;
- convertRectToSuperview:(NXRect *)aRect;
- convertPoint:(NXPoint *)p fromView:aView;
- convertPoint:(NXPoint *)aPoint toView:aView;
- convertSize:(NXSize *)aSize fromView:aView;
- convertSize:(NXSize *)aSize toView:aView;
- convertRect:(NXRect *)aRect fromView:aView;
- convertRect:(NXRect *)aRect toView:aView;

- superviewSizeChanged:(const NXSize *)oldSize;
- setAutoresizeSubviews:(BOOL)flag;
- setAutosizing:(unsigned int)mask;
- _windowRectChangedFrom:(const NXRect *)oldFrame to:(const NXRect *)newFrame;
- (unsigned int)autosizing;
- centerScanRect:(NXRect *)aRect;
- update;
- drawInSuperview;
- allocateGState;
- notifyToInitGState:(BOOL)flag;
- initGState;
- renewGState;
- clipToFrame:(const NXRect *)frameRect;
- (BOOL)isFocusView;
- setClipping:(BOOL)flag;
- (BOOL)doesClip;
- display;
- display:(const NXRect *)rects :(int)rectCount;
- (int)gState;
- freeGState;
- sizeTo:(NXCoord)width :(NXCoord)height;
- sizeBy:(NXCoord)deltaWidth :(NXCoord)deltaHeight;
- resizeSubviews:(const NXSize *)oldSize;
- descendantFrameChanged:sender;
- (NXRect *)frame;
- hitTest:(NXPoint *)aPoint;
- (BOOL)mouse:(NXPoint *)aPoint inRect:(NXRect *)aRect;
- findViewWithTag:(int)aTag;
- (int)tag;
- (BOOL)performKeyEquivalent:(NXEvent *)theEvent;
- (BOOL)acceptsFirstMouse;
- (BOOL)shouldDelayWindowOrderingForEvent:(NXEvent *)theEvent;
- addCursorRect:(const NXRect *)aRect cursor:anObj;
- removeCursorRect:(const NXRect *)aRect cursor:anObj;
- discardCursorRects;
- resetCursorRects;
- (BOOL)shouldDrawColor;
- dragImage:anImage at:(NXPoint *)viewLocation offset:(NXPoint *)initialOffset
      event:(NXEvent *)event pasteboard:(Pasteboard *)pboard source:
      sourceObj slideBack:(BOOL)slideFlag;
- registerForDraggedTypes:(const char *const *)newTypes count:(int)numTypes;
- unregisterDraggedTypes;
- dragFile:(const char *)filename fromRect:(NXRect *)rect 
              slideBack:(BOOL) aFlag event:(NXEvent *)event;
- copyPSCodeInside:(const NXRect *)rect to:(NXStream *)stream;
- writePSCodeInside:(const NXRect *)copyArea to:pasteboard;
- printPSCode:sender;
- faxPSCode:sender;
- faxPSCode:sender
    toList: (const char *const *) names 
    numberList: (const char *const *) numbers 
    sendAt:(time_t) when
    wantsCover: (BOOL) cFlag
    wantsNotify: (BOOL) nFlag
    wantsHires: (BOOL) hFlag
    faxName: (const char *) aString;
- (BOOL)knowsPagesFirst:(int *)firstPageNum last:(int *)lastPageNum;
- openSpoolFile:(char *)filename;
- beginPSOutput;
- beginPrologueBBox:(const NXRect *)boundingBox 
       creationDate:(const char *)dateCreated 
          createdBy:(const char *)anApplication
	      fonts:(const char *)fontNames forWhom:(const char *)user
	      pages:(int)numPages title:(const char *)aTitle;
- endHeaderComments;
- endPrologue;
- beginSetup;
- endSetup;
- beginPageSetupRect:(const NXRect *)aRect placement:(const NXPoint *)location;
- addToPageSetup;
- endPageSetup;
- endPage;
- beginTrailer;
- endTrailer;
- endPSOutput;
- spoolFile:(const char *)filename;
- (float)heightAdjustLimit;
- (float)widthAdjustLimit;
- adjustPageWidthNew:(float *)newRight left:(float)oldLeft
               right:(float)oldRight  limit:(float)rightLimit;
- adjustPageHeightNew:(float *)newBottom top:(float)oldTop
               bottom:(float)oldBottom limit:(float)bottomLimit;
- (BOOL)getRect:(NXRect *)theRect forPage:(int)page;
- placePrintRect:(const NXRect *)aRect offset:(NXPoint *)location;
- drawSheetBorder:(float)width :(float)height;
- drawPageBorder:(float)width :(float)height;
- (BOOL)canPrintRIB;
- (void*)_widget;
- _addCallback;
- _managedBy:parent;
- _manageChildren;
- _setWindow:(Window *)aWindow;
- _setWindow:(Window *)aWindow andSuperview:(View *)aView;
- _setBorderRect:(NXRect *)brect;
- translateCoords:(NXEvent *)nx;
@end

@interface View(WidgetSet)
#define SHIFT_MASK 1
#define CONTROL_MASK 2
- _init;
- (BOOL)_displayLockFocus;
- _displayUnlockFocus;
- _getFrame;
- _managedBy:parent wid:(void*)widget;
- _unManage;
- _destroy;
- makeNXEvent:(NXEvent *)nx fromXEvent:(XEvent *)event;
- _moveTo:(NXCoord)x :(NXCoord)y;
- _setFrame:(const NXRect *)aFrame;
- _setSize:(NXSize *)newSize;
- _setResize:(void *)policy;
- _setOffsets:(NXSize *)offsets;
- _setBorderShadow:(void *)shadow andThickness:(void *)thickness;
- _sizeTo:(NXCoord)width :(NXCoord)height;
@end
#endif /* _View_h_ */
