/* Macros and utility functions
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * stdmacros.h,v 1.19 1994/06/15 18:58:56 pfkeb Exp
 */

 
#ifndef _std_macros_h_
#define _std_macros_h_


#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/param.h>

#ifndef MAX
#define MAX(A,B) (((A) > (B)) ? (A) : (B))
#endif
#ifndef MIN
#define MIN(A,B) (((A) < (B)) ? (A) : (B))
#endif
#ifndef ABS
#define ABS(A) (((A) < 0) ? (-(A)) : (A))
#endif


/* Some compatibility macros */

#define NX_MALLOC( VAR, TYPE, NUM )		\
	((VAR) = (TYPE *) malloc(((unsigned)NUM)*sizeof(TYPE)))
#define X_MALLOC( VAR, TYPE, NUM )		\
	((VAR) = (TYPE *) malloc(((unsigned)NUM)*sizeof(TYPE)))

#define NX_REALLOC( VAR, TYPE, NUM )		\
	((VAR) = (TYPE *) realloc(VAR, ((unsigned)NUM)*sizeof(TYPE)))
#define X_REALLOC( VAR, TYPE, NUM )		\
	((VAR) = (TYPE *) realloc(VAR, ((unsigned)NUM)*sizeof(TYPE)))
	
#define NX_FREE( PTR ) free((PTR))
#define X_FREE( PTR ) free((PTR))

#define NX_ZONEMALLOC( Z, VAR, TYPE, NUM )		\
	((VAR) = (TYPE *) malloc(((unsigned)NUM)*sizeof(TYPE)))

#define NX_ZONEREALLOC( Z, VAR, TYPE, NUM )		\
	((VAR) = (TYPE *) realloc(VAR, ((unsigned)NUM)*sizeof(TYPE)))
	
#ifndef NBITSCHAR
#define NBITSCHAR 8
#endif NBITSCHAR

#ifndef NBITSINT
#define NBITSINT (sizeof(int)*NBITSCHAR)
#endif NBITSINT

#ifndef TRUE
#define TRUE 1
#endif FALSE
#ifndef FALSE
#define FALSE 0
#endif FALSE

/* I don't know where this should go: */
#ifndef	__NeXT__

#define X_NOBORDER 0

#endif
#endif
