/*
    xttools - various routines used by the Xlib portion of the GNUStep appkit

    Copyright (C) 1994, Adam Fedor.

    Don't use these routines directly in your application.  They are meant
    to be used internally by the appkit and may change at any time.

    xttools.h,v 1.1 1994/07/28 19:40:33 fedor Exp
*/

#ifndef _GNUSTEP_XTTOOLS_H_
#define _GNUSTEP_XTTOOLS_H_
#include <dpsclient/xwfriends.h>
#include <appkit/color.h>

/* Maintaining and using colormaps */
extern XStandardColormap *xtDefaultColormap(XWContext context);

/* Internal conversion of colors to pixels values */
extern u_long	xtGrayToPixel(XWContext context, float gray);
extern u_long	xtRGBToPixel(XWContext context, float red, 
			float green, float blue);
extern u_long	xtColorToPixel(XWContext context, NXColor color);

/* Internal conversion of image data to pixel values */
extern u_char	*xtMapColors(XWContext context, u_char **src, int colorspace,
	int bps, int spp, int ncolors, int planar, u_char *dest);

#endif
