/*  Archiving Category for SliderCell
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Scott Francis, Paul Kunz, and Imran Qureshi

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmSliderCell.m,v 1.7 1994/06/11 03:54:03 pfkeb Exp

*/

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "objc/typedstream.h"

#define NXTypedStream TypedStream
#include <appkit/SliderCell.h>

#include "archive-def.h"

@implementation SliderCell (XmArchiving)


- write:(TypedStream *)stream
{
    int i;
    
    [super write:stream];
    
#ifdef DEBUG
    printf("->SliderCell");
#endif

    i = [self isVertical];
    objc_write_float(stream, value);
    objc_write_float(stream, maxValue);
    objc_write_float(stream, minValue);
    objc_write_type(stream, "i", &i);
    return self;
}
@end
