/*
    streams - Definitions and macros for streams package 

    Copyright (C) 1994. Adam Fedor

    streams.c,v 1.2 1994/04/20 03:06:33 fedor Exp

    Right now this is just a simple package based on stdio meant to 
    provide compile compatability with NeXT's streams package.

 */
#include <streams/streams.h>

static const char *
type_for_mode(int mode)
{
    char *type = NULL;

    if (mode == NX_READONLY)
	type = "r";
    else if (mode == NX_WRITEONLY)
	type = "w";
    else if (mode == NX_READWRITE)
	type = "rw";

    return type;
}

NXStream *
NXOpenFile(int fd, int mode)
{
    NXStream 	*stream = NULL;
    const char*	type;

    type = type_for_mode(mode);
    if (type)
        stream = fdopen(fd, type);

    return stream;
}

/* Need a real streams package for this */
NXStream *
NXOpenMemory(const char *addr, int size, int mode)
{
    return NULL;
}

NXStream *
NXMapFile(const char *name, int mode)
{
    NXStream 	*stream = NULL;
    const char*	type;

    type = type_for_mode(mode);
    if (type)
        stream = fopen(name, type);

    return stream;
}

/* Need a real streams package for this */
int 
NXSaveToFile(NXStream *s, const char *name)
{
    return 0;
}

/* Need a real streams package for this */
void 
NXGetMemoryBuffer(NXStream *s, char **addr, int *len, int *maxlen)
{
}

/* Need a real streams package for this */
void 
NXCloseMemory(NXStream *s, int option)
{
    NXClose(s);
}

