/*
 * DVI previewer for X.
 *
 * Based on the original work by Eric Cooper, CMU, September 1985.
 *
 * Last edited on 7-Jul-1992 by Frank Griffel & Valentino Kyriakides 
 * under Acorn's RISCiX
 *
 * OPEN LOOK Styled by 
 *                        Frank Griffel and Valentino Kyriakides
 *
 * ATTENTION: The ONLY purpose that this software is reasonable for
 *            right now, is to demonstrate the usage of some of
 *            the XView (i.e. OPEN LOOK) objects and routines.
 *            IT IS BY NO MEANS QUALITY SOFTWARE AND THE AUTHORS
 *            MAKE ABSOLUTELY NO WARRANTIES ABOUT CORRECT BEHAVIOR
 *            OF THE SOFTWARE.
 *            Considering the development time of just 4 days,
 *            it runs quite stable and has a fairly amount of usability.
 *	      THIS PROGRAM MAY BE DISTRIBUTED AND COPIED FREELY
 *	      PROVIDED THAT THE ORIGINAL AUTHORS' NAMES ARE MENTIONED
 *            IN THE SOURCE.
 *
 *  Files that have changed from the original 'xdvi' distribution:
 *         Makefile
 *         dvi_draw.c
 *         dvi_init.c
 *         xdvi.c
 *
 *  This OPEN LOOK version has been built during an university project
 *  in June 1992. It work's but IT IS QUICK 'n DIRTY. Some functionality
 *  from the original xdvi have been removed for simplicity and easier
 *  adaption to XView. There are lots of things to do, some include:
 *         - clean up the whole code, there are funtions and variables
 *           that are not used any longer; split the code create some
 *           headers etc...
 *         - implement ERROR HANDLING, most error posibilities are
 *           NOT catched right now
 *	   - THERE'S NO MAN-PAGE ! WRITE ONE !
 *           (As for now, use the XView Help facility for questions)
 *	   - work over the 'Info' and 'Errors' button notices; 
 *           they will core dump if there are too many lines of information;
 *           a textsw or list panel would be a better display facility
 *	   - catch all output to oops and redirect
 *           it into a textsw or a notice, so that the user
 *           may look at errors when loading a new file;
 *           catch output from check_dvi_file
 *         - implement an XView conforming command line arguments
 *           scanning; reimplement the original xdvi options
 *         - implement a clean and XView conforming color handling
 *         - there should be an event loop that triggers all the other
 *           actions and catches resize events etc.; right now
 *           the canvas repaint procedure is called throughout the
 *           code; this is dirty !
 *         - re-implement the magnification glass
 *         - internationalize the whole thing
 *         - implement some good ideas, such as 'multi page preview'
 *           for example, by catching the split notification and
 *           handle a separate page counter for each view; another
 *           goodie would be a file browser in the file load frame
 *           ... and so it goes on and on ...
 *
 *	Compilation options:
 *	MSBITFIRST	store bitmaps internally with most significant bit first
 *	BMSHORT	store bitmaps in shorts instead of bytes
 *	BMLONG	store bitmaps in longs instead of bytes
 *	ALTFONT	default for -altfont option
 *	A4	use European size paper
 *	TEXXET	support reflection dvi codes (right-to-left typesetting)
 */

/* font used if the required one cannot be found */
#ifndef	ALTFONT
#define	ALTFONT	"cmr10"
#endif

/* we should use a reasonable page size */
#ifndef	A4
#define	DEFAULT_PAPER		"us"
#else
#define	DEFAULT_PAPER		"a4"
#endif

#include <ctype.h>

#define EXTERN           /* defines for correct inclusion of xdvi.h */
#define INIT(x) =x
#include "xdvi.h"
#include <stdlib.h>
#include <X11/Xutil.h>

/* some type definitions to make things easier; FG: not really needed ! */
#define	XtNumber(arr)	(sizeof(arr)/sizeof(arr[0]))
typedef	int		Position;
typedef	unsigned int	Dimension;
typedef	unsigned int	Pixel;

/* do we have sockets ? */
#ifdef	HAS_SIGIO
#include <fcntl.h>
#include <signal.h>
#endif

/* again some shorties; VK: dirty, should be removed */
static	Display	*DISP;
#define	DPY	DISP,
static	Screen	*SCRN;
#define	Flush()		XFlush(DISP)

#ifndef X11HEIGHT
#define	X11HEIGHT	8	/* Height of server default font */
#endif

/*
 * Command line flags. VK: Remove these ! They are no longer valid !
 */
static	_Xconst	char	*paper		= DEFAULT_PAPER;
static	char	*sidemargin, *topmargin;
static	char	*xoffset, *yoffset;
static	Boolean	reverse;
static	int	bak_shrink;
static	char	*debug_arg;
static	char	*curr_page;

static	Pixel	fore_Pixel, back_Pixel;
static	Pixel	brdr_Pixel, hl_Pixel, cr_Pixel;

static	char	*fore_color;
static	char	*back_color;
static	char	*brdr_color;
static	char	*high_color;
static	char	*curs_color;
static	GC	foreGC, highGC;
static	GC	ruleGC;
static	GC	foreGC2;

/* FG: things that shouldn't stay here any longer */
#define	clip_w	mane.width
#define	clip_h	mane.height
static	Dimension	window_w, window_h;
static	Position	main_x, main_y;
static	int	home_x, home_y;
static	int	min_x, max_x, min_y, max_y;


static	XImage	*image;

struct WindowRec mane	= {NULL, 3, 0, 0, 0, 0, 0, MAXDIM, 0, MAXDIM};
struct WindowRec currwin = {NULL, 3, 0, 0, 0, 0, 0, MAXDIM, 0, MAXDIM};
#ifndef NeXT
extern	double	atof();
#endif

/* FG: The following functions may need some work to make them fit into       */
/*     a 'real' OPEN LOOK application, e.g. the GC and WINDOW stuff           */
/*     (no need for currwin.base stuff and so o)n ... but functionality is OK */

/********************************
 *	  tpic routines		*
 *******************************/

/* Things we need from spec_draw, unfortunately */

#define	toint(x)	((int) ((x) + 0.5))
#define	xconv(x)	(toint(specialConv*(x))/shrink_factor + PXL_H)
#define	yconv(y)	(toint(specialConv*(y))/shrink_factor + PXL_V)

/*
 *	Draw a line from (fx,fy) to (tx,ty).
 *	Right now, we ignore pen_size.
 */
void
line_btw(fx, fy, tx, ty)
int fx, fy, tx, ty;
{
	register int	fcx = xconv(fx),
			tcx = xconv(tx),
			fcy = yconv(fy),
			tcy = yconv(ty);

	if ((fcx < max_x || tcx < max_x) && (fcx >= min_x || tcx >= min_x) &&
	    (fcy < max_y || tcy < max_y) && (fcy >= min_y || tcy >= min_y))
		XDrawLine(DISP, FGWINDOW(currwin), ruleGC,
		    fcx - currwin.base_x, fcy - currwin.base_y,
		    tcx - currwin.base_x, tcy - currwin.base_y);
}

/*
 *	Draw a dot at (x,y)
 */
void
dot_at(x, y)
	int	x, y;
{
	register int	cx = xconv(x),
			cy = yconv(y);

	if (cx < max_x && cx >= min_x && cy < max_y && cy >= min_y)
	    XDrawPoint(DISP, FGWINDOW(currwin), ruleGC,
		cx - currwin.base_x, cy - currwin.base_y);
}


/*
 *	Put a rectangle on the screen.  hl determines the GC.
 */

void
put_rectangle(x, y, w, h, hl)
	int x, y, w, h;
	Boolean hl;
{
 	if (x < max_x && x + w >= min_x && y < max_y && y + h >= min_y) {
		XFillRectangle(DISP, FGWINDOW(currwin), hl ? highGC : ruleGC,
		    x - currwin.base_x, y - currwin.base_y,
		    w ? w : 1, h ? h : 1);
	}
}

void
put_bitmap(bitmap, x, y)
	register struct bitmap *bitmap;
	register int x, y;
{

	if (debug & DBG_BITMAP)
		Printf("X(%d,%d)\n", x - currwin.base_x, y - currwin.base_y);
	if (x < max_x && x + bitmap->w >= min_x &&
	    y < max_y && y + bitmap->h >= min_y) {
		image->width = bitmap->w;
		image->height = bitmap->h;
		image->data = bitmap->bits;
		image->bytes_per_line = bitmap->bytes_wide;
		XPutImage(DISP, FGWINDOW(currwin), foreGC, image,
			0, 0,
			x - currwin.base_x, y - currwin.base_y,
			bitmap->w, bitmap->h);
		if (foreGC2)
		    XPutImage(DISP, FGWINDOW(currwin), foreGC2, image,
			0, 0,
			x - currwin.base_x, y - currwin.base_y,
			bitmap->w, bitmap->h);
	}
}

/* VK: again, dirty stuff but as we mentioned: it was quick 'n dirty */
#define	window_x 0
#define	window_y 0
#define	mane_base_x	mane.base_x
#define	mane_base_y	mane.base_y


/* FG: Use this to model the button callback procs */
/* |||
 *	Currently the event handler does not coordinate XCopyArea requests
 *	with GraphicsExpose events.  This can lead to problems if the window
 *	is partially obscured and one, for example, drags a scrollbar.
 */

#define	XKEY(ev)	(ev).xkey
#define	XANY(ev)	(ev).xany
#define	XCONFIG(ev)	(ev).xconfigure
#define	XEXPOSE(ev)	(ev).xexpose
#define	XMOTION(ev)	(ev).xmotion
#define	XBUTTON(ev)	(ev).xbutton
#define	ISEXPOSE(ev)	((ev).type == Expose)

/* VK: no longer valid; implement a XView event driven control              */
/*     This function is here only to show you what you have to re-implement */
#ifdef WANT_KEYSTROKE   /* indeed, never defined */
static	void
keystroke(ch, number0, arg0, eventp)
	char	ch;
	int	number0;
	Boolean	arg0;
	XEvent	*eventp;
{
	int	next_page;

	next_page = current_page;
	switch (ch) {
	    case 'q':
	    case '\003':	/* control-C */
	    case '\004':	/* control-D */
		exit(0);
	    case 'n':
	    case 'f':
	    case ' ':
	    case '\r':
	    case '\n':
		/* scroll forward; i.e. go to relative page */
		next_page = current_page + (arg0 ? number0 : 1);
		break;
	    case 'p':
	    case 'b':
	    case '\b':
	    case '\177':	/* Del */
		/* scroll backward */
		next_page = current_page - (arg0 ? number0 : 1);
		break;
	    case 'g':
		/* go to absolute page */
		next_page = (arg0 ? number0 - pageno_correct :
		    total_pages - 1);
		break;
	    case 'P':		/* declare current page */
		pageno_correct = arg0 * number0 - current_page;
		return;
	    case 'k':		/* toggle keep-position flag */
		keep_flag = (arg0 ? number0 : !keep_flag);
		return;
	    case '\f':
		/* redisplay current page */
		break;
	    case '^':
		home(True);
		return;
	    case 'l':
		if (mane.base_x <= 0) goto bad;
		scrollmane(mane.base_x - 2 * clip_w / 3, mane.base_y);
		return;
	    case 'r':
		if (mane.base_x >= page_w - clip_w) goto bad;
		scrollmane(mane.base_x + 2 * clip_w / 3, mane.base_y);
		return;
	    case 'u':
		if (mane.base_y <= 0) goto bad;
		scrollmane(mane.base_x, mane.base_y - 2 * clip_h / 3);
		return;
	    case 'd':
		if (mane.base_y >= page_h - clip_h) goto bad;
		scrollmane(mane.base_x, mane.base_y + 2 * clip_h / 3);
		return;
	    case 'c':	/* unchecked scrollmane() */
		scrollwindow(&mane, mane.base_x + XKEY(*eventp).x - clip_w/2,
		    mane.base_y + XKEY(*eventp).y - clip_h/2);
		XWarpPointer(DISP, None, None, 0, 0, 0, 0,
		    clip_w/2 - XKEY(*eventp).x, clip_h/2 - XKEY(*eventp).y);
		return;
	    case 'M':
		home_x = (XKEY(*eventp).x - (y_bar ? BAR_THICK : 0)
		    + mane.base_x) * mane.shrinkfactor;
		home_y = (XKEY(*eventp).y - (x_bar ? BAR_THICK : 0)
		    + mane.base_y) * mane.shrinkfactor;
		return;

	    case '\020':	/* Control P */
		Printf("Unit = %d, bitord = %d, byteord = %d\n",
		    BitmapUnit(DISP), BitmapBitOrder(DISP),
		    ImageByteOrder(DISP));
		return;
	    case 's':
		if (!arg0) {
		    int temp;
		    number0 = ROUNDUP(unshrunk_page_w, window_w - 2);
		    temp = ROUNDUP(unshrunk_page_h, window_h - 2);
		    if (number0 < temp) number0 = temp;
		}
		if (number0 <= 0) goto bad;
		if (number0 == mane.shrinkfactor) return;
		mane.shrinkfactor = number0;
		init_page();
		if (number0 != 1 && number0 != bak_shrink) {
		    bak_shrink = number0;
		    reset_fonts();
		}
		reconfig();
		break;
	    case 'S':
		if (!arg0) goto bad;
		if (number0 < 0) goto bad;
		if (number0 == density) return;
		density = number0;
		reset_fonts();
		if (mane.shrinkfactor == 1) return;
		break;
	    case 'R':
		/* reread DVI file */
		--dvi_time;	/* then it will notice a change */
		break;
	    default:
		goto bad;
	}
	if (0 <= next_page && next_page < total_pages) {
	    if (current_page != next_page) {
		current_page = next_page;
		hush_spec_now = hush_spec;
	    }
	    Flush();
	    return;	/* don't use longjmp here:  it might be called from
			 * within the toolkit, and we don't want to longjmp out
			 * of Xt routines. */
	}
	bad:  XBell(DISP, 10);
}
#endif /* WANT_KEYSTROKE */


static	void
redraw(windowrec)
	struct WindowRec *windowrec;
{
	currwin = *windowrec;

/* min, max stuff throughout the source isn't really needed any more */
	min_x = currwin.min_x + currwin.base_x;
	min_y = currwin.min_y + currwin.base_y;
	max_x = currwin.max_x + currwin.base_x;
	max_y = currwin.max_y + currwin.base_y;

	Flush();
        draw_page();
        hush_spec_now = True;
}

/* VK: silly that this function is still alive, but someone may call it from */
/*     outer space ...                                                       */
void
redraw_page()
{
	redraw(&mane);
	Flush();
}

/* FG: Usage is no longer valid (since options have been removed for now */
/*     FIX THIS and implement a XView help facility (dvitool.info file)  */
static	volatile void
usage() {
	Fputs("\
Usage: xdvi [+[<page>]] [-s <shrink>] [-S <density>] [-p <pixels>] [-l] [-rv]\n\
	[-paper <papertype>] [-mgs[n] <size>] [-altfont <font>]\n\
	[-margins <dimen>] [-sidemargin <dimen>] [-topmargin <dimen>]\n\
	[-offsets <dimen>] [-xoffset <dimen>] [-yoffset <dimen>] [-keep]\n\
	[-hushspecials] [-hushchars] [-hush]\n\
	[-fg <color>] [-bg <color>] [-hl <color>] [-bd <color>] \
[-cr <color>]\n\
	[-bw <width>] [-geometry <geometry>] [-icongeometry <geometry>]\n\
	[-iconic] [-display <host:display>] [-copy] [-thorough] dvi_file\n",
	stderr);
	exit(1);
}

static	int
atopix(arg)
	_Xconst	char	*arg;
{
	int	len	= strlen(arg);

	return (len > 2 && arg[len - 2] == 'c' && arg[len - 1] == 'm' ?
		1.0 / 2.54 : 1.0) * atof(arg) * pixels_per_inch + 0.5;
}

/**
 **	Main programs start here.
 **/

/* FG: there ARE some of the follwing that should be removed  ! */
static	char	*icon_geometry;
static	Boolean	copy	= 2;
static	Boolean	thorough;
static	char	*display;
static	char	*geometry;
static	char	*margins;
static	char	*offsets;
static	Boolean	hush;

/* VK: Adjust options, no longer valid ! USE XView resource routines !      */
/*     They are just here so that you can see what you have to re-implement */
/*
static	struct option {
	_Xconst	char	*name;
	_Xconst	char	*resource;
	enum	{FalseArg, TrueArg, StickyArg, SepArg} argclass;
	enum	{BooleanArg, StringArg, NumberArg} argtype;
	int	classcount;
	caddr_t	address;
}	options[] = {
{"-display",	NULL,		SepArg,	StringArg, 1,	(caddr_t) &display},
{"-d",		"debugLevel",	SepArg,	StringArg, 1,	(caddr_t) &debug_arg},
{"+",		NULL,		StickyArg, StringArg, 1,(caddr_t) &curr_page},
{"-s",		"shrinkFactor", SepArg, NumberArg, 1,	(caddr_t) &shrink_factor},
{"-S",		NULL,		SepArg, NumberArg, 2,	(caddr_t) &density},
{"-density",	"densityPercent", SepArg, NumberArg, 1,	(caddr_t) &density},
{"-p",		"pixelsPerInch", SepArg, NumberArg, 1,	(caddr_t) &pixels_per_inch},
{"-margins",	"Margin",	SepArg,	StringArg, 3,	(caddr_t) &margins},
{"-sidemargin",	"sideMargin",	SepArg,	StringArg, 1,	(caddr_t) &sidemargin},
{"-topmargin",	"topMargin",	SepArg,	StringArg, 1,	(caddr_t) &topmargin},
{"-offsets",	"Offset",	SepArg,	StringArg, 3,	(caddr_t) &offsets},
{"-xoffset",	"xOffset",	SepArg,	StringArg, 1,	(caddr_t) &xoffset},
{"-yoffset",	"yOffset",	SepArg,	StringArg, 1,	(caddr_t) &yoffset},
{"-paper",	"paper",	SepArg,	StringArg, 1,	(caddr_t) &paper},
{"-altfont",	"altFont",	SepArg,	StringArg, 1,	(caddr_t) &alt_font},
{"-l",		NULL,		TrueArg, BooleanArg, 2,	(caddr_t) &list_fonts},
{"+l",		"listFonts",	FalseArg, BooleanArg, 1,(caddr_t) &list_fonts},
{"-rv",		NULL,		TrueArg, BooleanArg, 2,	(caddr_t) &reverse},
{"+rv",		"reverseVideo",	FalseArg, BooleanArg, 1,(caddr_t) &reverse},
{"-hush",	NULL,		TrueArg, BooleanArg, 6,	(caddr_t) &hush},
{"+hush",	"Hush",		FalseArg, BooleanArg, 5,(caddr_t) &hush},
{"-hushspecials", NULL,		TrueArg, BooleanArg, 2,	(caddr_t) &hush_spec},
{"+hushspecials", "hushSpecials", FalseArg, BooleanArg, 1,(caddr_t) &hush_spec},
{"-hushchars",	NULL,		TrueArg, BooleanArg, 2,	(caddr_t) &hush_chars},
{"+hushchars",	"hushLostChars", FalseArg, BooleanArg, 1,(caddr_t) &hush_chars},
{"-bw",		NULL,		SepArg,	NumberArg, 2,	(caddr_t) &bwidth},
{"-borderwidth", "borderWidth",	SepArg,	NumberArg, 1,	(caddr_t) &bwidth},
{"-fg",		NULL,		SepArg,	StringArg, 2,	(caddr_t) &fore_color},
{"-foreground",	"foreground",	SepArg,	StringArg, 1,	(caddr_t) &fore_color},
{"-bg",		NULL,		SepArg,	StringArg, 2,	(caddr_t) &back_color},
{"-background",	"background",	SepArg,	StringArg, 1,	(caddr_t) &back_color},
{"-bd",		NULL,		SepArg,	StringArg, 2,	(caddr_t) &brdr_color},
{"-bordercolor","borderColor",	SepArg,	StringArg, 1,	(caddr_t) &brdr_color},
{"-hl",		"highlight",	SepArg,	StringArg, 1,	(caddr_t) &high_color},
{"-cr",		"cursorColor",	SepArg,	StringArg, 1,	(caddr_t) &curs_color},
{"-geometry",	"geometry",	SepArg,	StringArg, 1,	(caddr_t) &geometry},
{"-icongeometry","iconGeometry",StickyArg, StringArg, 1,(caddr_t) &icon_geometry},
{"-iconic",	NULL,		TrueArg, BooleanArg, 2,	(caddr_t) &iconic},
{"+iconic",	"iconic",	FalseArg, BooleanArg, 1,(caddr_t) &iconic},
{"-keep",	NULL,		TrueArg, BooleanArg, 2,	(caddr_t) &keep_flag},
{"+keep",	"keepPosition",	FalseArg, BooleanArg, 1,(caddr_t) &keep_flag},
{"-copy",	NULL,		TrueArg, BooleanArg, 2,	(caddr_t) &copy},
{"+copy",	"copy",		FalseArg, BooleanArg, 1,(caddr_t) &copy},
{"-thorough",	NULL,		TrueArg, BooleanArg, 2,	(caddr_t) &thorough},
{"+thorough",	"thorough",	FalseArg, BooleanArg, 1,(caddr_t) &thorough},
{"-mgs",	NULL,		SepArg, NumberArg, 2,	(caddr_t) &mg_size[0]},
{"-mgs1",	"magnifierSize1",SepArg, NumberArg, 1,	(caddr_t) &mg_size[0]},
{"-mgs2",	"magnifierSize2",SepArg, NumberArg, 1,	(caddr_t) &mg_size[1]},
{"-mgs3",	"magnifierSize3",SepArg, NumberArg, 1,	(caddr_t) &mg_size[2]},
{"-mgs4",	"magnifierSize4",SepArg, NumberArg, 1,	(caddr_t) &mg_size[3]},
{"-mgs5",	"magnifierSize5",SepArg, NumberArg, 1,	(caddr_t) &mg_size[4]},
};
*/

/* FG: FUNCTION parse_options is no longer valid and here ! Re-implement     */
/*     one that is XView conform. There was no time ( and money ... )        */


static	_Xconst	char	*paper_types[] = {
	"us",		"8.5x11",
	"usr",		"11x8.5",
	"legal",	"8.5x14",
	"foolscap",	"13.5x17.0",	/* ??? */

	/* ISO `A' formats, Portrait */
	"a1",		"59.4x84.0cm",
	"a2",		"42.0x59.4cm",
	"a3",		"29.7x42.0cm",
	"a4",		"21.0x29.7cm",
	"a5",		"14.85x21.0cm",
	"a6",		"10.5x14.85cm",
	"a7",		"7.42x10.5cm",

	/* ISO `A' formats, Landscape */
	"a1r",		"84.0x59.4cm",
	"a2r",		"59.4x42.0cm",
	"a3r",		"42.0x29.7cm",
	"a4r",		"29.7x21.0cm",
	"a5r",		"21.0x14.85cm",
	"a6r",		"14.85x10.5cm",
	"a7r",		"10.5x7.42cm",

	/* ISO `B' formats, Portrait */
	"b1",		"70.6x100.0cm",
	"b2",		"50.0x70.6cm",
	"b3",		"35.3x50.0cm",
	"b4",		"25.0x35.3cm",
	"b5",		"17.6x25.0cm",
	"b6",		"13.5x17.6cm",
	"b7",		"8.8x13.5cm",

	/* ISO `B' formats, Landscape */
	"b1r",		"100.0x70.6cm",
	"b2r",		"70.6x50.0cm",
	"b3r",		"50.0x35.3cm",
	"b4r",		"35.3x25.0cm",
	"b5r",		"25.0x17.6cm",
	"b6r",		"17.6x13.5cm",
	"b7r",		"13.5x8.8cm",

	/* ISO `C' formats, Portrait */
	"c1",		"64.8x91.6cm",
	"c2",		"45.8x64.8cm",
	"c3",		"32.4x45.8cm",
	"c4",		"22.9x32.4cm",
	"c5",		"16.2x22.9cm",
	"c6",		"11.46x16.2cm",
	"c7",		"8.1x11.46cm",

	/* ISO `C' formats, Landscape */
	"c1r",		"91.6x64.8cm",
	"c2r",		"64.8x45.8cm",
	"c3r",		"45.8x32.4cm",
	"c4r",		"32.4x22.9cm",
	"c5r",		"22.9x16.2cm",
	"c6r",		"16.2x11.46cm",
	"c7r",		"11.46x8.1cm",
};

static	Boolean
set_paper_type() {
	_Xconst	char	*arg, *arg1;
	char	temp[21];
	_Xconst	char	**p;
	char	*q;

	if (strlen(paper) > sizeof(temp) - 1) return False;
	arg = paper;
	q = temp;
	for (;;) {	/* convert to lower case */
	    char c = *arg++;
	    if (c >= 'A' && c <= 'Z') c ^= ('a' ^ 'A');
	    *q++ = c;
	    if (c == '\0') break;
	}
	arg = temp;
	/* perform substitutions */
	for (p = paper_types; p < paper_types + XtNumber(paper_types); p += 2)
	    if (strcmp(temp, *p) == 0) {
		arg = p[1];
		break;
	    }
	arg1 = index(arg, 'x');
	if (arg1 == NULL) return False;
	unshrunk_paper_w = atopix(arg);
	unshrunk_paper_h = atopix(arg1 + 1);
	return (unshrunk_paper_w != 0 && unshrunk_paper_h != 0);
}

/*-------------------------------------------------------------------*/
/* VK: These are for XView stuff */

/* All the stuff that have to be included ... */

#include <xview/xview.h>	/* just the general ...            */
#include <xview/frame.h>	/* for the frames                  */
#include <xview/panel.h>        /* for the panels                  */
#include <xview/notice.h>	/* for the notices                 */
#include <xview/openmenu.h>     /* for the menus                   */
#include <xview/cms.h>		/* for the canvas color            */
#include <xview/canvas.h>       /* for the canvas                  */
#include <xview/icon.h>		/* for the cute little pictures    */
#include <xview/scrollbar.h>    /* yes indeed, for the scrollbars  */
#include <xview/rect.h>         /* to hold base frame dimensions   */
#include <xview/xv_xrect.h>	/* for the canvas repaint proc     */
#include <xview/sel_pkg.h>      /* the selection stuff for drops   */
#include <xview/dragdrop.h>	/* stuff for dropping is needed    */
#include <xview/svrimage.h>     /* yes, there ARE pictures in here */
#include <X11/Xlib.h>           /* for graphical drawing in canvas */
#include <X11/Xatom.h>          /* Atom stuff for select and drop  */

/* table of possible colors; work on this in the future */
unsigned long  *pixel_table;

/* FG: change these pictures ! */

static unsigned short idle_bitmap[] = {		/* normal drop target picture */
#include <images/off.pr>
};

/* VK: not used right now since there's nothing to drag out of dvitool */
static unsigned short busy_bitmap[] = {		/* picture, when drop is busy */
#include <images/on.pr>
};

char *strdup();                        /* declare this, there's no header yet */


/* Some defines, we don't like 'magic' numbers within the source */

#define  DVI_MAIN_PANEL_HEIGHT  50     /* How much space for the panel        */
#define  DVI_DROP_HEIGHT  16           /* Size of the drop area, and          */
#define  DVI_DROP_WIDTH   64           /* therefore the size of the used icon */
#define  PAINT_WIDTH  2000             /* canvas window width                 */
#define  PAINT_HEIGHT 3500             /* canvas window height (draw area)    */
#define  DEFAULT_DENSITY  40           /* default font density value          */
#define  dvi_width   560               /* size of the dvitool's base frame    */
#define  dvi_height  520               /* initially, just a hint, should be   */
                                       /* user defineable                     */

#define  GREY   0		       /* The canvas background color         */
				       /* future use                          */

/* Global stuff */

	Frame                   frame;
        Canvas                  canvas;
	Panel			page_num;
        Panel                   panel;
        Panel_item              message;
        Panel_drop_target_item  dvi_drop_target;
        Selection_requestor     dvi_sel_req;
        Rect                    *base_dims, icon_rect;

static char  lft_foot[40], rgt_foot[40];   /* footer strings */
static char  msg_string[80];               /* message string */

extern int  err_cnt;
extern char *error_array[];

/* a maximum of 30 output lines each at most 100 characters from dviinfo */
/* VK: need dynamic allocation for this ! FIX IT */
int          linelen = 100;
static char  *info_array[50];
int          inf_cnt;

/* the main work is started from here: draw a beautiful TeX page into the */
/* canvas                                                                 */
void
can_repaint(canvas, paint_window, dpy, xwin, area)
Canvas          canvas;
Xv_Window       paint_window;
Display         *dpy;
Window          xwin;
Xv_xrectlist    *area;
{

        mane.win = xwin;    /* most other xdvi routines use 'mane' for    */
                            /* drawing; were too lasy to change right now */
        if (*dvi_name)
          redraw(&mane);    /* start drawing (if there's a file ... )     */
                            /* ATTENTION: This redrawing is NOT optimised */
                            /*            in any way at this point        */
	Flush();
}

/* printing some information about this program with the 'About' button */
void
show_about()
{
	Xv_notice	notice;

	notice = xv_create(panel, NOTICE,
			NOTICE_MESSAGE_STRINGS,
			  "This program has been written by",
			  "Frank Griffel and Valentino Kyriakides",
			  "during the hot days of June 1992.",
			  "It is based on the public domain",
			  "TeX dvi-file previewer 'xdvi' and its",
			  "main reason for being is to demonstrate",
			  "the XView (i.e. OPEN LOOK) stuff.",
			  " ",
			  "THIS IS VERSION 0.9 (beta).",
			  "ABSOLUTELY NO WARRANTIES APPLY !",
			NULL,
			NOTICE_BUTTON_YES,	"Ok",
			XV_SHOW,		TRUE,
			XV_HELP_DATA, "dvitool:AboutNotice",
			NULL);
	xv_destroy_safe(notice);
}

/* printing some information about the loaded dvifile with the "Info"  button */
/* ATTENTION: The dviinfo output may have too many lines for a notice !       */
/*            This may occur if the dvi-file uses a lot of fonts. A textsw    */
/*            that is scrollable or a list panel would be probably better     */
/*            Another idea is to show a 'more' button that triggers the next  */
/*            notice containing more dviinfo output lines ...                 */
/* VK: Fix this ! */
void
show_info()
{
        Xv_notice       notice;
	int             i;

	inf_cnt = 0;
	if (*dvi_name) {
		process_dvi_file(dvi_file);
		info_array[inf_cnt] = NULL;
	}
	else {
		info_array[0] = (char *)malloc(linelen);
		info_array[1] = (char *)malloc(linelen);
		sprintf(info_array[0], "NO DVI-FILE LOADED !");
		sprintf(info_array[1],
			 "So there's nothing to give information about.");
		info_array[2] = NULL;
	}

        notice = xv_create(panel, NOTICE,
                        NOTICE_MESSAGE_STRINGS_ARRAY_PTR,  info_array,
                        NOTICE_BUTTON_YES,      "Ok",
                        XV_SHOW,                TRUE,
			XV_HELP_DATA, "dvitool:InfoNotice",
                        NULL);
        xv_destroy_safe(notice);
	if (*dvi_name)
	  for (i = 0; i < inf_cnt; i++)
		free(info_array[i]);
	else {
	  free(info_array[0]);
	  free(info_array[1]);
	}
}

void
show_error()
{
        Xv_notice       notice;

        if (err_cnt == 0) {
          error_array[0] = (char *)malloc(linelen);
          sprintf(error_array[0],
                "There were no errors while scanning the dvi-file");
          error_array[1] = NULL;
        }

        notice = xv_create(panel, NOTICE,
                        NOTICE_MESSAGE_STRINGS_ARRAY_PTR,  error_array,
                        NOTICE_BUTTON_YES,      "Ok",
                        XV_SHOW,                TRUE,
			XV_HELP_DATA, "dvitool:ErrorNotice",
                        NULL);
        xv_destroy_safe(notice);
}

/* Global stuff, used across the NOTIFY_PROCS functions   */
/* Three windows: One for input of a filename and         */
/*                one for input of the page number        */
/*                one for density slider                  */

Frame		file_subframe, page_subframe, slider_subframe;
Panel		file_subpanel, page_subpanel, slider_subpanel;

/* procs that map the two windows on the screen when their time has come ... */
/* Could be included directly into the code ...grmpf                         */

void page_show()
{
	xv_set(page_subframe, XV_SHOW, TRUE, NULL);
}

void file_show()
{
	xv_set(file_subframe, XV_SHOW, TRUE, NULL);
}

void slider_show()
{
	xv_set(slider_subframe, XV_SHOW, TRUE, NULL);
}


/* procs for getting and working on the values from the above input windows  */
	
void
page_proc(item, event)
Panel_item  item;
Event       *event;
{
	current_page = (int)xv_get(item, PANEL_VALUE) - 1;
	sprintf(rgt_foot, "%s %d", "page:", current_page + 1);
        xv_set(frame, FRAME_RIGHT_FOOTER, rgt_foot, NULL);
/* shouldn't do the following; better: make a refresh notification */
	XClearWindow(DISP, mane.win);
	if (*dvi_name)
	  can_repaint(canvas, 0, DISP, mane.win, 0); /* dangerous dummies ?! */
}

void
file_proc(item, event)
Panel_item  item;
Event       *event;
{
	dvi_name = strdup(xv_get(item, PANEL_VALUE));
	if (*dvi_name) {
	  sprintf(msg_string, "%s %s %s", "Loading file", dvi_name, "..."); 
          xv_set(message, PANEL_LABEL_STRING, msg_string, NULL);
	  current_page = 0; /* always begin on page 0 with new file */
	  open_dvi_file();
	  if (*dvi_name) { /* did open_dvi_file return a valid dvi-filename */
	    xv_set(page_num, PANEL_MAX_VALUE, total_pages - 1, NULL);
	    sprintf(lft_foot, "%s %s", "file:", dvi_name);
            xv_set(frame, FRAME_LEFT_FOOTER, lft_foot, NULL);
	    sprintf(rgt_foot, "%s %d", "page:", current_page + 1);
            xv_set(frame, FRAME_RIGHT_FOOTER, rgt_foot, NULL);
	  }
	  sprintf(msg_string, "%s", ""); 
          xv_set(message, PANEL_LABEL_STRING, msg_string, NULL);
	}
/* shouldn't do the following; better: make a refresh notification */
	XClearWindow(DISP, mane.win);
	if (*dvi_name)
	  can_repaint(canvas, 0, DISP, mane.win, 0); /* dangerous dummies ?! */
}

void
dens_proc(item, value, event)
Panel_item   item;
int          value;
Event        *event;
{
	density = (int)xv_get(item, PANEL_VALUE);
	reset_fonts();
/* shouldn't do the following; better: make a refresh notification */
	XClearWindow(DISP, mane.win);
	if (*dvi_name)
	  can_repaint(canvas, 0, DISP, mane.win, 0); /* dangerous dummies ?! */
}


/* procs for displaying and choosing a File and a Size menu */

void
file_menu_proc(menu, menu_item)
Menu       menu;
Menu_item  menu_item;
{
	char  *action;

	action = strdup(xv_get(menu_item, MENU_STRING));
	if (!strcmp(action, "Load..."))
		(void) file_show();
	else if (!strcmp(action, "Errors..."))
		(void) show_error();
	else if (!strcmp(action, "Info..."))
		(void) show_info();
	else if (!strcmp(action, "About..."))
		(void) show_about();
	else if (!strcmp(action, "Quit")) {
		xv_destroy_safe(frame);
		exit(0);
	}
	free(action);
}

void
size_proc(menu, menu_item)
Menu       menu;
Menu_item  menu_item;
{
	char  *size;

	size = strdup(xv_get(menu_item, MENU_STRING));
	switch (size[0]) {
		case 'T' : mane.shrinkfactor = shrink_factor = 4;
			   reset_fonts();
			   break;
		case 'S' : mane.shrinkfactor = shrink_factor = 3;
			   reset_fonts();
			   break;
		case 'B' : mane.shrinkfactor = shrink_factor = 2;
			   reset_fonts();
			   break;
		case 'L' : mane.shrinkfactor = shrink_factor = 1;
			   reset_fonts();
			   break;
	}
/* shouldn't do the following; better: make a refresh notification */
	XClearWindow(DISP, mane.win);
	if (*dvi_name)
	  can_repaint(canvas, 0, DISP, mane.win, 0); /* dangerous dummies ?! */
}

/* click on 'Previous' button to get the previous page */
void
prev_proc()
{
	current_page--;
	if (current_page < 0)
		current_page = 0;
        /* synchronize the numeric text panel with the next/previous buttons */
	xv_set(page_num, PANEL_VALUE, current_page + 1, NULL);
	sprintf(rgt_foot, "%s %d", "page:", current_page + 1);
        xv_set(frame, FRAME_RIGHT_FOOTER, rgt_foot, NULL);
/* shouldn't do the following; better: make a refresh notification */
	XClearWindow(DISP, mane.win);
	if (*dvi_name)
	  can_repaint(canvas, 0, DISP, mane.win, 0); /* dangerous dummies ?! */
}

/* click on 'Next' button to get the next page */
void
next_proc()
{
	current_page++;
	if (current_page >= total_pages)
		current_page = total_pages - 1;
        /* synchronize the numeric text panel with the next/previous buttons */
	xv_set(page_num, PANEL_VALUE, current_page + 1, NULL);
	sprintf(rgt_foot, "%s %d", "page:", current_page + 1);
        xv_set(frame, FRAME_RIGHT_FOOTER, rgt_foot, NULL);
/* shouldn't do the following; better: make a refresh notification */
	XClearWindow(DISP, mane.win);
	if (*dvi_name)
	  can_repaint(canvas, 0, DISP, mane.win, 0); /* dangerous dummies ?! */
}

/* procs that deal with a little drop area at the upper right */
/* The first recognizes that there IS a drop,                 */
/* the second evaluates and works on the results              */

int
dvi_drop_target_ntfy_proc(item, value, event)
Panel_drop_target_item  item;
int			value;
Event			*event;
{
	switch (event_action(event)) {
          case ACTION_DRAG_COPY:
          case ACTION_DRAG_MOVE: {
            int  length, format;
            char *name_string;

/* FG: must check for XV_ERROR from dnd_decode_drop */
/* ATTENTION: dnd_decode_drop returns always XV_ERROR ! Why ? */
	    dnd_decode_drop(dvi_sel_req, event);
            xv_set(dvi_sel_req, SEL_TYPE, XA_STRING, NULL);
            name_string = (char *)xv_get(dvi_sel_req,
                                           SEL_DATA, &length, &format);
            if (length != SEL_ERROR) {
	      strcpy(dvi_name, name_string);
              free(name_string);
              sprintf(msg_string, "%s %s %s", "Loading file", dvi_name, "...");
              xv_set(message, PANEL_LABEL_STRING, msg_string, NULL);
              current_page = 0; /* always begin on page 0 with new file */
              open_dvi_file();
	      if (*dvi_name) { /* did open_dvi_file return a valid dvifile */
                xv_set(page_num, PANEL_MAX_VALUE, total_pages - 1, NULL);
                sprintf(lft_foot, "%s %s", "file:", dvi_name);
                xv_set(frame, FRAME_LEFT_FOOTER, lft_foot, NULL);
                sprintf(rgt_foot, "%s %d", "page:", current_page + 1);
                xv_set(frame, FRAME_RIGHT_FOOTER, rgt_foot, NULL);
/* shouldn't do the following; better: make a refresh notification */
                XClearWindow(DISP, mane.win);
/* dangerous dummies ?! */
                can_repaint(canvas, 0, DISP, mane.win, 0);
	      }
              sprintf(msg_string, "%s", "");
              xv_set(message, PANEL_LABEL_STRING, msg_string, NULL);
	    }
            xv_set(dvi_sel_req, SEL_TYPE_NAME, "_SUN_SELECTION_END", NULL);
            (void)xv_get(dvi_sel_req, SEL_DATA, &length, &format);
            dnd_done(dvi_sel_req);
            break;
          }
	}
}

/* look for keys pressed over the canvas; look for drops */
/* FG: the whole functionality of the original 'keystroke' function should */
/*     be re-immplemented here                                             */
void
event_handler(window, event)
Xv_Window	window;
Event		*event;
{
	switch (event_action(event)) {
	  case WIN_RESIZE :
	/* get the dimensions, since we like the drop area to be positioned  */
        /* at the upper right corner. This is done relativly to the right    */
        /* border */
	        base_dims = (Rect *)xv_get(panel, XV_RECT);
                    /* install the area 20 points left from the right border */
		xv_set(dvi_drop_target,	XV_X, rect_right(base_dims)
                               - DVI_DROP_WIDTH - 20, /* image width - 20 */
			NULL);
		break;
	}
}

/* VK: XView global stuff ends here (for now) */
/* ------------------------------------------------------------------ */
/* FG: Valentino's dviinfo stuff begins here ... grmpf */

#define post		248
#define post_post	249
#define dvi_id		2
#define nop			138
#define fnt_def1	243
#define fnt_def2	244
#define fnt_def3	245
#define fnt_def4	246

typedef unsigned long four_bytes;

int cur_command;
double unity;

void print_dimen(four_bytes x)
{
	double val;
	char *unity_name;
        char  ftemp[100];
	
	val = unity*x / 10000.0;
	unity_name = (char *)malloc(linelen);
	if (val > 10)
	{
		strcpy(unity_name,"cm");
		val /= 10;
	}
	else
		strcpy(unity_name,"mm");
	sprintf(ftemp, "%5.2f %s", val, unity_name);
	strcat(info_array[inf_cnt], ftemp);
	free(unity_name);
}

four_bytes read_unsigned(df, bytes)
FILE *df;
int bytes;
{
	four_bytes x;
	
	x = getc(df);
	while (bytes-- >1)
	{
		x *= 256;
		x += getc(df);
	}
	return(x);
}


int reverse_getc(df)
FILE *df;
{
	fseek(df, -2, SEEK_CUR);
	return(getc(df));
}


process_dvi_file(df)
FILE *df;
{
	four_bytes design_size, at_size;
	four_bytes num, den, magnification;
	four_bytes page_width, page_height;
	int		   a, l, pages;
	double	   font_size;
	fpos_t	   post_loc;	
	
	
	fseek(df,0,SEEK_END);
				
	while ((cur_command = reverse_getc(df)) == 223)
		;
	reverse_getc(df); reverse_getc(df); reverse_getc(df);
	reverse_getc(df);	cur_command = reverse_getc(df);
	post_loc = (fpos_t)read_unsigned(df,4);
				
	fseek(df,post_loc,SEEK_SET);
	cur_command = (int) read_unsigned(df,1);
	read_unsigned(df,4);
			
	num = read_unsigned(df,4);  den = read_unsigned(df,4);
	magnification = read_unsigned(df,4);
	unity = (num*((double) magnification/1000))/den;
	page_height = read_unsigned(df,4);
	page_width = read_unsigned(df,4);
	read_unsigned(df,2);
	pages = (int) read_unsigned(df,2);
	info_array[inf_cnt] = (char *)malloc(linelen);
	sprintf(info_array[inf_cnt++],"The dvi-file contains %d pages.", pages);
	info_array[inf_cnt] = (char *)malloc(linelen);
	sprintf(info_array[inf_cnt], "Each page is ");
	print_dimen(page_width); strcat(info_array[inf_cnt], " wide and ");
	print_dimen(page_height); strcat(info_array[inf_cnt++], " high.");
	info_array[inf_cnt] = (char *)malloc(linelen);
        sprintf(info_array[inf_cnt++],
			"The dvi-file needs the following fonts:");
	info_array[inf_cnt] = (char *)malloc(linelen);
	while (cur_command != post_post)
	{
		int   lc = 0;
	        char  ftemp[100];

		cur_command = (int) read_unsigned(df,1);
		switch (cur_command)
		{
			case nop:
			case post_post : break;
			case fnt_def1 :
			case fnt_def2 :
			case fnt_def3 :
			case fnt_def4 :
				read_unsigned(df,cur_command-fnt_def1+1);
				read_unsigned(df,4);
				at_size = read_unsigned(df,4);
				design_size = read_unsigned(df,4);
				a = (int) read_unsigned(df,1);
				l = (int) read_unsigned(df,1);
				while (a-- > 0)
					info_array[inf_cnt][lc++] = getc(df);
				while (l-- > 0)
					info_array[inf_cnt][lc++] = getc(df);
				font_size = (at_size*((double)magnification/1000))/design_size;
				info_array[inf_cnt][lc] = '\0';
				sprintf(ftemp, " at size %5.3f", font_size);
				strcat(info_array[inf_cnt++], ftemp);
				info_array[inf_cnt] = (char *)malloc(linelen);
				break;
		}
	}
}
/* ------------------------------------------------------------------ */

/*
 *	main program
 */


int
main(argc, argv)
	int argc;
	char **argv;
{

/* VK: XView declaration stuff */

        Menu                    file_menu, size_menu;
        Scrollbar               h_scrollbar, v_scrollbar;
        Server_image            idle_glyph, busy_glyph, appl_image;
        Cms			cms;
	Icon			appl_icon;

/* FG: on color systems the background color is grey, e.g. the color     */
/*     that is used by the 3D OPEN LOOK style                            */
/*     FIX THIS !!! It's not portable and dirty, must be user-defineable */
static Xv_singlecolor  colors[] = {
			{ 192, 192, 192 }
                       };


/* build a color map segment containing one color (grey) */
        cms = (Cms) xv_create(NULL, CMS,
                                 CMS_SIZE, 1,
                                 CMS_COLORS, colors,
                                 NULL);

/* table to reference if we want to use a color */
        pixel_table = (unsigned long *)xv_get(cms, CMS_INDEX_TABLE);



/* ------------------------------------------------------------------ */

	if ((DISP = XOpenDisplay(display)) == NULL)
            oops("Can't open display");
        SCRN = DefaultScreenOfDisplay(DISP);

/* allocate some storage for the filename */
	dvi_name = (char *)malloc(80);

/* always begin at page 0; FG: FIX THIS, must be user-defineable */
/* ATTENTION: current_page uses DVI-file specific page numbering */
/*            starting at 0; all page numbers are shown +1       */
	current_page = 0;

/* default values in header, footer and message */
	sprintf(lft_foot, "%s", "file:");
	sprintf(rgt_foot, "%s", "page:");
	
	err_cnt = 0; /* no errors yet */
	shrink_factor = 3;
	mane.shrinkfactor = shrink_factor;

	if (sidemargin) home_x = atopix(sidemargin);
	if (topmargin) home_y = atopix(topmargin);
	offset_x = xoffset ? atopix(xoffset) : pixels_per_inch;
	offset_y = yoffset ? atopix(yoffset) : pixels_per_inch;
	if (!set_paper_type()) oops("Don't recognize paper type %s", paper);

	init_font_open();
	if (argc == 2) {
	  strcpy(dvi_name, argv[1]); /* use argument as dvi filename */
	  sprintf(msg_string, "%s %s %s", "Loading file", dvi_name, "..."); 
	  sprintf(rgt_foot, "%s %d", "page:", current_page + 1);
	  open_dvi_file();
	  sprintf(lft_foot, "%s %s", "file:", dvi_name);
	  sprintf(msg_string, "%s", "");
	} else {
	    strcpy(dvi_name, "");   /* no file name yet */
	    sprintf(msg_string, "%s", "no file loaded"); 
	}

/* FG: The whole color stuff below need to be worked over and should be */
/*     re-written in a smart and XView conforming way                   */

	/*
	 *	X11 colors
	 */

	if (reverse) {
	    if (!fore_color) fore_Pixel = WhitePixelOfScreen(SCRN);
	    if (!back_color) back_Pixel = BlackPixelOfScreen(SCRN);
	    fore_color = back_color = (char *) &fore_color;
	} else {
	    if (!fore_color) fore_Pixel = BlackPixelOfScreen(SCRN);
	    if (!back_color) back_Pixel = pixel_table[GREY];
	}
	if (!brdr_color) brdr_Pixel = fore_Pixel;
	{
	    XGCValues	values;
	    Pixel	set_bits = (Pixel) (fore_Pixel & ~back_Pixel);
	    Pixel	clr_bits = (Pixel) (back_Pixel & ~fore_Pixel);
#define	MakeGC(fcn, fg, bg)	(values.function = fcn, values.foreground=fg,\
		values.background=bg,\
		XCreateGC(DISP, RootWindowOfScreen(SCRN),\
			GCFunction|GCForeground|GCBackground, &values))

	    if (copy == 2) copy = (PlanesOfScreen(SCRN) > 1);
	    if (copy || (set_bits && clr_bits))
		ruleGC = MakeGC(GXcopy, fore_Pixel, back_Pixel);
	    if (copy) foreGC = ruleGC;
	    else if (!thorough && ruleGC) {
		foreGC = ruleGC;
		puts("Note:  overstrike characters may be incorrect.");
	    }
	    else {
		if (set_bits) foreGC = MakeGC(GXor, set_bits, 0);
		if (clr_bits)
		    *(foreGC ? &foreGC2 : &foreGC) =
			MakeGC(GXandInverted, clr_bits, 0);
		if (!ruleGC) ruleGC = foreGC;
	    }
	    highGC = ruleGC;
	    if (high_color)
		highGC = MakeGC(GXcopy, hl_Pixel, back_Pixel);
	}
	if (!curs_color)
	    cr_Pixel = high_color ? hl_Pixel : fore_Pixel;
	{
	    XColor bg_Color, cr_Color;

	    bg_Color.pixel = back_Pixel;
	    XQueryColor(DISP, DefaultColormapOfScreen(SCRN), &bg_Color);
	    cr_Color.pixel = cr_Pixel;
	    XQueryColor(DISP, DefaultColormapOfScreen(SCRN), &cr_Color);
	}

	image = XCreateImage(DISP, DefaultVisualOfScreen(SCRN), 1, XYBitmap, 0,
			     (char *)NULL, 0, 0, BITS_PER_BMUNIT, 0);
	image->bitmap_unit = BITS_PER_BMUNIT;
#ifndef	MSBITFIRST
	image->bitmap_bit_order = LSBFirst;
#else
	image->bitmap_bit_order = MSBFirst;
#endif
	{
	    short endian = MSBFirst << 8 | LSBFirst;
	    image->byte_order = *((char *) &endian);
	}

/*----------------------------------------------------------------------*/
/* VK: XView stuff begins right here */


	/* initialize the whole XView world */
	xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);

	/* put the two feet onto the ground (base, ok ?) */
	frame = (Frame)xv_create(NULL, FRAME, 
				 FRAME_LABEL,		argv[0],
				 FRAME_SHOW_FOOTER,	TRUE,
				 FRAME_LEFT_FOOTER,     lft_foot,
				 FRAME_RIGHT_FOOTER,	rgt_foot,
				 XV_WIDTH,		dvi_width,
				 XV_HEIGHT,		dvi_height,
				 WIN_EVENT_PROC,	event_handler,
				 WIN_CONSUME_EVENTS,
					WIN_RESIZE,
					WIN_ASCII_EVENTS,
					NULL,
				 XV_HELP_DATA, "dvitool:BaseFrame",
				 NULL);

	/* create a server image that can be used as an icon */
	appl_image = (Server_image)xv_create(NULL, SERVER_IMAGE,
				SERVER_IMAGE_BITMAP_FILE,   "lion.xbm",
				NULL);

	/* create the application's icon */
	appl_icon = (Icon)xv_create(NULL, ICON,
			ICON_IMAGE, appl_image,
			XV_HELP_DATA, "dvitool:LionIcon",
			NULL);

	xv_set(frame,
		FRAME_ICON,         appl_icon,
		NULL);

	/* our main panel that holds the main functions                    */
        /* restrict the height or the canvas will really move DOWN UNDER ! */
	panel = xv_create(frame, PANEL,
			  XV_HEIGHT, 	      DVI_MAIN_PANEL_HEIGHT,
			  XV_HELP_DATA, "dvitool:MainPanel",
                          NULL);

	/* get the dimensions, since we like the drop area to be positioned  */
        /* at the upper right corner. This is done relativly to the right    */
        base_dims = (Rect *)xv_get(panel, XV_RECT);

	/* From this menu we'll get the dvi files */
	file_menu = (Menu)xv_create(NULL, MENU,
	/* if you change these strings change them also in 'file_menu_proc' ! */
			MENU_STRINGS, "Load...", "Errors...",
                                      "About...", "Info...",
        /* the empty menu item may not be OPEN LOOK conform ! */
				      "  ", "Quit", NULL,
			MENU_NOTIFY_PROC, file_menu_proc,
			XV_HELP_DATA, "dvitool:FileMenu",
			NULL),

	/* This one allows zooming, shrinking     */
	size_menu = (Menu)xv_create(NULL, MENU,
		MENU_NOTIFY_PROC,	size_proc,
		MENU_STRINGS, 	"Tiny", "Small", "Big", "Large", NULL,
		XV_HELP_DATA, "dvitool:SizeMenu",
		NULL);

	/* All the control buttons, some have menus, some not ... that's life */
	(void) xv_create(panel, PANEL_BUTTON,
			 PANEL_LABEL_STRING,	"File",
			 PANEL_ITEM_MENU,	file_menu,
			 XV_HELP_DATA, "dvitool:FileMenuButton",
			 NULL);

	(void) xv_create(panel, PANEL_BUTTON,
			 PANEL_LABEL_STRING,	"Size",
			 PANEL_ITEM_MENU,	size_menu,
			 XV_HELP_DATA, "dvitool:SizeMenuButton",
			 NULL);

	(void) xv_create(panel, PANEL_BUTTON,
			 PANEL_LABEL_STRING,	"Density...",
			 PANEL_NOTIFY_PROC,	slider_show,
			 XV_HELP_DATA, "dvitool:DensityButton",
			 NULL);
	
	(void) xv_create(panel, PANEL_BUTTON,
			 PANEL_LABEL_STRING,	"Page...",
			 PANEL_NOTIFY_PROC,	page_show,
			 XV_HELP_DATA, "dvitool:PageButton",
			 NULL);

	(void) xv_create(panel, PANEL_BUTTON,
			 PANEL_LABEL_STRING,	"Previous",
			 PANEL_NOTIFY_PROC,	prev_proc,
			 XV_HELP_DATA, "dvitool:PrevButton",
			 NULL);

	(void) xv_create(panel, PANEL_BUTTON,
			 PANEL_LABEL_STRING,	"Next",
			 PANEL_NOTIFY_PROC,	next_proc,
			 XV_HELP_DATA, "dvitool:NextButton",
			 NULL);


	/* Create the two (normal, busy) pictures for the drop area */
	idle_glyph = xv_create(NULL, SERVER_IMAGE,
			       XV_HEIGHT,		DVI_DROP_HEIGHT,
			       XV_WIDTH,		DVI_DROP_WIDTH,
			       SERVER_IMAGE_DEPTH,	 1,
			       SERVER_IMAGE_BITS,	idle_bitmap,
			       NULL);

/* VK: not used right now since there's nothing to drag FROM dvitool */
	busy_glyph = xv_create(NULL, SERVER_IMAGE,
			       XV_HEIGHT,		DVI_DROP_HEIGHT,
			       XV_WIDTH,		DVI_DROP_WIDTH,
			       SERVER_IMAGE_DEPTH,	 1,
			       SERVER_IMAGE_BITS,	busy_bitmap,
			       NULL);


	/* The target area itself, later one should be able to drop into the */
        /* main canvas itself, too. Implement this.                          */
	dvi_drop_target = xv_create(panel, PANEL_DROP_TARGET,
			PANEL_DROP_GLYPH,	idle_glyph,
			PANEL_DROP_BUSY_GLYPH,	busy_glyph,
			PANEL_NOTIFY_PROC,	dvi_drop_target_ntfy_proc,
                    /* install the area 20 points left from the right border */
			XV_X, rect_right(base_dims)
                               - DVI_DROP_WIDTH - 20, /* image width - 20 */
			XV_HELP_DATA, "dvitool:DropTarget",
			NULL);

	/* Create a SELECTION_REQUESTOR, someone has to take care of the */
	/* orphaned drop data ... :-(                                    */
	dvi_sel_req = xv_get(dvi_drop_target, PANEL_DROP_SEL_REQ);

	/* Message panel, used for general warnings, hints etc */
	message = (Panel_item)xv_create(panel, PANEL_MESSAGE,
				PANEL_LABEL_STRING,	msg_string,
	/* messages should go UNDER the buttons not next to them */
				PANEL_NEXT_ROW,		-1, /* default gap */
				XV_HELP_DATA, "dvitool:PanelMessage",
				NULL);

	/* The display area for formatted TeX pages */
	canvas = (Canvas)xv_create(frame, CANVAS,
			           CANVAS_WIDTH,           PAINT_WIDTH,
		   	           CANVAS_HEIGHT,          PAINT_HEIGHT,
			           CANVAS_AUTO_SHRINK,     FALSE,
        			   CANVAS_AUTO_EXPAND,     FALSE,
			 	   CANVAS_X_PAINT_WINDOW,	TRUE,
				   CANVAS_REPAINT_PROC,		can_repaint,
				   WIN_EVENT_PROC,		event_handler,
				   WIN_CONSUME_EVENTS,
					WIN_ASCII_EVENTS,
					NULL,
				   XV_HELP_DATA, "dvitool:MainCanvas",
				   NULL);

	/* Scrollbars for this area */
	h_scrollbar = (Scrollbar)xv_create(canvas, SCROLLBAR,
				   SCROLLBAR_SPLITTABLE, TRUE,
				   SCROLLBAR_DIRECTION, SCROLLBAR_HORIZONTAL,
				   NULL);

	v_scrollbar = (Scrollbar)xv_create(canvas, SCROLLBAR,
				   SCROLLBAR_SPLITTABLE, TRUE,
				   SCROLLBAR_DIRECTION, SCROLLBAR_VERTICAL,
				   NULL);


	/* Subframes and panels for the input functions */
	file_subframe = (Frame)xv_create(frame, FRAME_CMD,
					 FRAME_LABEL,	"File Load",
				         FRAME_CMD_PIN_STATE, FRAME_CMD_PIN_IN,
					 XV_HELP_DATA, "dvitool:LoadFrame",
					 NULL);

	page_subframe = (Frame)xv_create(frame, FRAME_CMD,
					 FRAME_LABEL,	"Page Number",
				         FRAME_CMD_PIN_STATE, FRAME_CMD_PIN_IN,
					 XV_HELP_DATA, "dvitool:PageFrame",
					 NULL);

	slider_subframe = (Frame)xv_create(frame, FRAME_CMD,
					 FRAME_LABEL,	"Font Density",
				         FRAME_CMD_PIN_STATE, FRAME_CMD_PIN_IN,
					 XV_HELP_DATA, "dvitool:DensityFrame",
					 NULL);

	file_subpanel = (Panel)xv_get(file_subframe, FRAME_CMD_PANEL,
				XV_HELP_DATA, "dvitool:FileLoadPanel",
				NULL);

	page_subpanel = (Panel)xv_get(page_subframe, FRAME_CMD_PANEL,
				XV_HELP_DATA, "dvitool:PageInputPanel",
				NULL);

	(void) xv_create(file_subpanel, PANEL_TEXT,
			 PANEL_LABEL_STRING, 		"Name:",
			 PANEL_NOTIFY_PROC,		file_proc,
			 PANEL_VALUE_DISPLAY_LENGTH,	18,
			 XV_HELP_DATA, "dvitool:FileNamePanel",
			 NULL);	

	page_num =  xv_create(page_subpanel, PANEL_NUMERIC_TEXT,
			 PANEL_LABEL_STRING, 	"Page:",
			 PANEL_NOTIFY_PROC,	page_proc,
			 PANEL_MIN_VALUE,	1,
			 XV_HELP_DATA, "dvitool:PageNumberPanel",
			 NULL);	

	slider_subpanel = (Panel)xv_get(slider_subframe, FRAME_CMD_PANEL,
				XV_HELP_DATA, "dvitool:DensityFramePanel",
				NULL);

	(void) xv_create(slider_subpanel, PANEL_SLIDER,
				PANEL_LABEL_STRING, "Font-Density:",
				PANEL_MIN_VALUE,    0,    /* defaults, but */
				PANEL_MAX_VALUE,    100,  /* nicer code    */
				PANEL_NOTIFY_PROC,  dens_proc,
				PANEL_SHOW_RANGE,   TRUE,
			 	PANEL_VALUE,	    DEFAULT_DENSITY,
				XV_HELP_DATA, "dvitool:DensitySlider",
				NULL);

	/* avoid paging behind end of dvi-file */
	xv_set(page_num, PANEL_MAX_VALUE, total_pages - 1, NULL);

	/* initial message if no file has been loaded */
        xv_set(message, PANEL_LABEL_STRING, msg_string, NULL);

	/* Use default size values for some things, so fit them */
	window_fit(page_subpanel);
	window_fit(file_subpanel);
	window_fit(file_subframe);
	window_fit(page_subframe);
	window_fit(slider_subpanel);
	window_fit(slider_subframe);
	window_fit(frame);

	/* Aaannnnnnnd, Aaaactionnnnnnnnnnn ... */
	xv_main_loop(frame);
}
