
/* 
 * PlotController.m -- Implementation file for the PlotController class 
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or implied, as to its
 * fitness for any particular use.
 *
 */

#import "PlotController.h"
#import "PlotView.h"
#import <appkit/Application.h>
#import <appkit/Listener.h>
#import <appkit/Pasteboard.h>
#import <appkit/Window.h>
#import <appkit/ScrollView.h>
#import <appkit/Text.h>
#import <stdlib.h> 
#import <string.h> 
#include <mach.h>

@implementation PlotController

- appDidInit:sender 
/*
 * Responds to a message that's sent just before the application
 * gets the first event.  PlotController initializes its inputText
 * instance variable.  It makes itself the inputText's delegate and
 * the services delegate for the application.  It also ensures that 
 * the application's single window becomes the key window.
 */
{
	inputText = [theScrollView docView];
	[inputText setDelegate:self];
	[[NXApp appListener] setServicesDelegate:self];
	[[thePlotView window] makeKeyAndOrderFront:self]; 
	return self;
}

- textDidGetKeys:theText isEmpty:(BOOL)flag
/*
 * Responds to a message the Text object sends when its text changes.
 * PlotController causes the PlotView to clear itself when the text changes.
 */
{
	return [thePlotView clear:self];
}

- requestPlot:(id)pasteboard userData:(const char *)userData error: (char **)msg
/*
 * Responds to a request from another application for the plotting service.
 * PlotController copies the data from the supplied pasteboard into the Text object
 * and then sends a plot: message to the PlotView.
 */
{
	char	*data, *scratch;
	int	 length;

	[NXApp activateSelf:NO]; 
	[pasteboard types];
	if ([pasteboard readType:NXAsciiPboardType data:&data length:&length]) {
		if(scratch = malloc(length+1)) {
			strncpy(scratch, data, length);
			scratch[length]='\0';
			[[inputText selectAll:self] replaceSel:scratch];
			free(scratch);
		}
		vm_deallocate(task_self(), (vm_address_t)data, (vm_size_t)length);
		[thePlotView plot:self];
	}
	return self;
}


- plotView:sender providePoints:(NXStream **)stream
/*
 * Responds to a message the PlotView sends requesting the points to plot.  
 * PlotController responds by giving the PlotView access to the Text 
 * object's stream.
 */
{
	*stream = [inputText stream];
	return self;
}

- plotView:sender pointDidChange:(NXPoint *)aPoint
/*
 * Responds to a message the PlotView sends notifying its delegate 
 * that a point has been added.  PlotController responds by adding the point to
 * the end of the list in the Text object.
 */
{
	int	endPos;
	char	buffer[100];

	sprintf(buffer, "%d, %d\n", (int)aPoint->x, (int)aPoint->y);
	endPos = [inputText byteLength];
	[inputText setSel:endPos :endPos];
	[inputText scrollSelToVisible];
	[inputText replaceSel:buffer];
	return self;
}

@end



