/**

*       SREC Definitions

**/



#define TRUE    1

#define FALSE   0

#define YES     1

#define NO      0

#define EOS     '\0'                    /* end-of-string constant */

#define MAXSTR  256                     /* maximum string size + 1 */



/*

* The following definitions are for Macintosh Lightspeed C since that

* environment does not support command line DEFINEs.  Remove comments

* as necessary.

*/

/*

#define MAC             1

#define LSC             1

*/



/**

*       Environment Definitions (zero here; may be redefined at compile time)

**/



#ifndef MSDOS

#define MSDOS           0               /* MS-DOS operating system */

#endif

#ifndef VMS

#define VMS             0               /* VMS operating system */

#endif

#ifndef ATT

#define ATT             0               /* ATT Unix */

#endif

#ifndef BSD

#define BSD             0               /* Berkeley Unix */

#endif

#ifdef UNIX

#undef UNIX

#endif

#define UNIX            (ATT || BSD)    /* generic Unix operating system */

#ifndef MAC

#define MAC             0               /* Macintosh operating system */

#endif



#ifndef MSC

#define MSC             0               /* Microsoft C compiler */

#endif

#ifndef VAXC

#define VAXC            0               /* VAX C compiler */

#endif

#ifndef LSC

#define LSC             0               /* Lightspeed C compiler */

#endif

#ifndef MPW

#define MPW             0               /* MPW C (Macintosh) */

#endif

#ifndef AZTEC

#define AZTEC           0               /* Aztec C (Macintosh) */

#endif



#if BSD

#define strchr  index

#define strrchr rindex

#else

#define index   strchr

#define rindex  strrchr

#endif



#if AZTEC               /* text file routine redefintion for Aztec */

#ifdef fgetc

#undef fgetc

#endif

#define fgetc   agetc

#ifdef fputc

#undef fputc

#endif

#define fputc   aputc

#endif



#if VMS                         /* exit status values */

#define OK      0x18000001L

#define ERR     0x1800FFFBL

#else

#define OK      0

#define ERR     1

#endif



/*      Base filename lengths   */

#if MSDOS

#define BASENAMLEN      12

#endif

#if UNIX

#define BASENAMLEN      14

#endif

#if VMS

#define BASENAMLEN      78

#endif

#if MAC

#define BASENAMLEN      31

#endif

#define MAXEXTLEN       4               /* longest filename extension */



#define WSIZE   3                       /* bytes per 56000 word */

#define OVRHD   3                       /* S-record byte overhead */

#define MAXBYTE 32                      /* max data bytes per S-record */

#define MAXBUF  (MAXBYTE + OVRHD) * 2   /* maximum byte buffer size */

#define MAXADDR ((unsigned)0xFFFF)      /* max address value */



#define MSPACES 4                       /* number of memory spaces */

#define XMEM    0                       /* memory space array offsets */

#define YMEM    1

#define LMEM    2

#define PMEM    3



#define NONE    0                       /* OMF record codes */

#define START   1

#define END     2

#define DATA    3

#define BDATA   4

#define SYMBOL  5

#define COMMENT 6



#define RECORD  1                       /* OMF field types */

#define HEXVAL  2



#define NEWREC  '_'                     /* new record indicator */



struct srec {                           /* S-record structure */

                FILE *fp;

                unsigned checksum;

                char *p;

                char buf[MAXBUF + 1];

                };



char *strcpy (), *strncpy ();

char *strcat (), *strncat ();

#if BSD

char *sprintf ();

char *index (), *rindex ();

#else

char *strchr (), *strrchr ();

#endif



#if MSDOS               /* reference DOS version number */

#if MSC

extern unsigned char _osmajor;

#endif

#endif

